/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.utils;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.integration.SupplementariesCompat;
import pepjebs.mapatlases.integration.TwilightForestCompat;

public enum MapType {
    VANILLA("map_", Items.f_42573_, Items.f_42676_),
    MAGIC("magicmap_", MapType.tf("filled_magic_map"), MapType.tf("magic_map")),
    MAZE("mazemap_", MapType.tf("filled_maze_map"), MapType.tf("maze_map")),
    ORE_MAZE("mazemap_", MapType.tf("filled_ore_map"), MapType.tf("ore_map"));

    private static final Map<Item, MapType> FROM_ITEM;
    private static final Set<Item> EMPTY;
    private final String keyPrefix;
    public final Item filled;
    public final Item empty;
    public final String translationKey;

    private MapType(String keyPrefix, Item filled, Item empty) {
        this.keyPrefix = keyPrefix;
        this.filled = filled;
        this.empty = empty;
        this.translationKey = filled == null ? "Missing" : filled.m_5524_();
    }

    public static MapType fromKey(String mapString, MapItemSavedData data) {
        if (MapAtlasesMod.TWILIGHTFOREST && TwilightForestCompat.isMazeOre(data)) {
            return ORE_MAZE;
        }
        for (MapType t : MapType.values()) {
            if (!mapString.startsWith(t.keyPrefix)) continue;
            return t;
        }
        return VANILLA;
    }

    public String makeKey(int id) {
        return this.keyPrefix + id;
    }

    @Nullable
    public Integer findKey(String s) {
        if (s.startsWith(this.keyPrefix)) {
            return Integer.parseInt(s.substring(this.keyPrefix.length()));
        }
        return null;
    }

    public static boolean isEmptyMap(Item i) {
        return EMPTY.contains(i);
    }

    public static MapType fromItem(Item item) {
        return FROM_ITEM.get(item);
    }

    private static Item tf(String id) {
        if (MapAtlasesMod.TWILIGHTFOREST) {
            return Registry.f_122827_.m_6612_(new ResourceLocation("twilightforest", id)).orElse(null);
        }
        return null;
    }

    @Nullable
    public Pair<String, MapItemSavedData> getMapData(Level level, int id) {
        String key = this.keyPrefix + id;
        MapItemSavedData data = null;
        if (this == VANILLA) {
            data = level.m_7489_(key);
        }
        if (this == MAGIC && MapAtlasesMod.TWILIGHTFOREST) {
            data = TwilightForestCompat.getMagic(level, key);
        } else if ((this == MAZE || this == ORE_MAZE) && MapAtlasesMod.TWILIGHTFOREST) {
            data = TwilightForestCompat.getMaze(level, key);
        }
        return data == null ? null : Pair.of((Object)key, (Object)data);
    }

    public Integer getHeight(MapItemSavedData data) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case VANILLA -> {
                if (MapAtlasesMod.SUPPLEMENTARIES) {
                    yield SupplementariesCompat.getSlice(data);
                }
                yield null;
            }
            case MAZE, ORE_MAZE -> {
                if (MapAtlasesMod.TWILIGHTFOREST) {
                    yield TwilightForestCompat.getSlice(data);
                }
                yield null;
            }
            case MAGIC -> null;
        };
    }

    public ColumnPos getCenter(double px, double pz, int scale) {
        if (this == MAGIC && MapAtlasesMod.TWILIGHTFOREST) {
            return TwilightForestCompat.getMagicMapCenter((int)px, (int)pz);
        }
        int j = Mth.m_14107_((double)((px + 64.0) / (double)scale));
        int k = Mth.m_14107_((double)((pz + 64.0) / (double)scale));
        int mapCenterX = j * scale + scale / 2 - 64;
        int mapCenterZ = k * scale + scale / 2 - 64;
        return new ColumnPos(mapCenterX, mapCenterZ);
    }

    public ItemStack createNewMapItem(int destX, int destZ, byte scale, Level level, @Nullable Integer height, ItemStack atlas) {
        ItemStack newMap = ItemStack.f_41583_;
        if (this == VANILLA) {
            newMap = height != null && MapAtlasesMod.SUPPLEMENTARIES ? SupplementariesCompat.createSliced(level, destX, destZ, scale, true, false, height) : MapItem.m_42886_((Level)level, (int)destX, (int)destZ, (byte)scale, (boolean)true, (boolean)false);
            if (MapAtlasesMod.SUPPLEMENTARIES && SupplementariesCompat.hasAntiqueInk(atlas)) {
                SupplementariesCompat.setMapAntique(newMap, level);
            }
        } else if (this == MAZE && MapAtlasesMod.TWILIGHTFOREST) {
            if (height == null) {
                return ItemStack.f_41583_;
            }
            newMap = TwilightForestCompat.makeMaze(destX, destZ, scale, level, height);
        } else if (this == ORE_MAZE && MapAtlasesMod.TWILIGHTFOREST) {
            if (height == null) {
                return ItemStack.f_41583_;
            }
            newMap = TwilightForestCompat.makeOre(destX, destZ, scale, level, height);
        } else if (this == MAGIC && MapAtlasesMod.TWILIGHTFOREST) {
            newMap = TwilightForestCompat.makeMagic(destX, destZ, scale, level);
        }
        return newMap;
    }

    public boolean hasMarkers() {
        return this != MAGIC;
    }

    public int getDiscoveryReach(@Nullable Integer height) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case VANILLA -> {
                if (height != null && MapAtlasesMod.SUPPLEMENTARIES) {
                    yield SupplementariesCompat.getSliceReach();
                }
                yield 128;
            }
            case MAZE, ORE_MAZE -> 16;
            case MAGIC -> 512;
        };
    }

    public float getDefaultZoomFactor() {
        if (this == MAGIC) {
            return 0.33333334f;
        }
        return 1.0f;
    }

    public Component getName() {
        return Component.m_237115_((String)this.translationKey);
    }

    static {
        FROM_ITEM = Arrays.stream(MapType.values()).collect(Collectors.toMap(t -> t.filled, c -> c, (existing, replacement) -> existing, IdentityHashMap::new));
        EMPTY = (Set)Util.m_137537_(() -> {
            HashSet<Item> s = new HashSet<Item>();
            for (MapType v : MapType.values()) {
                Item t = v.empty;
                if (t != null) {
                    s.add(t);
                }
                Registry.f_122827_.m_6612_(new ResourceLocation("supplementaries:slice_map")).ifPresent(s::add);
            }
            return s;
        });
    }
}

