/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.entity_handlers.ETFBlockEntityWrapper;
import traben.entity_texture_features.entity_handlers.ETFEntityWrapper;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFTexturePropertiesUtils;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFApi {
    public static final int ETFApiVersion = 6;
    @Deprecated
    public static ETFConfig getETFConfigObject = new ETFConfig();

    public static ETFConfig getETFConfigObject() {
        return ETFClientCommon.ETFConfigData;
    }

    public static ETFConfig getCopyOfETFConfigObject() {
        return ETFConfig.copyFrom(ETFClientCommon.ETFConfigData);
    }

    public static ETFConfig getDefaultETFConfigObject() {
        return new ETFConfig();
    }

    public static void setETFConfigObject(ETFConfig newETFConfig) {
        ETFClientCommon.ETFConfigData = newETFConfig;
        ETFApi.saveETFConfigChangesAndResetETF();
    }

    public static void saveETFConfigChangesAndResetETF() {
        ETFUtils2.saveConfig();
        ETFManager.resetInstance();
    }

    public static void resetETF() {
        ETFManager.resetInstance();
    }

    @NotNull
    public static ResourceLocation getCurrentETFVariantTextureOfEntity(@NotNull Entity entity, @NotNull ResourceLocation defaultTexture) {
        ResourceLocation etfIdentifier;
        ETFEntityWrapper etfEntity = new ETFEntityWrapper(entity);
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, etfEntity, ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
            return etfIdentifier;
        }
        return defaultTexture;
    }

    @NotNull
    public static ResourceLocation getCurrentETFVariantTextureOfEntity(@NotNull BlockEntity entity, @NotNull ResourceLocation defaultTexture, UUID uuidForBlockEntity) {
        ResourceLocation etfIdentifier;
        ETFBlockEntityWrapper etfEntity = new ETFBlockEntityWrapper(entity, uuidForBlockEntity);
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, etfEntity, ETFManager.TextureSource.BLOCK_ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null && (etfIdentifier = etfTexture.getTextureIdentifier(etfEntity)) != null) {
            return etfIdentifier;
        }
        return defaultTexture;
    }

    @Nullable
    public static ResourceLocation getCurrentETFEmissiveTextureOfEntityOrNull(@NotNull Entity entity, @NotNull ResourceLocation defaultTexture) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTexture, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            return etfTexture.getEmissiveIdentifierOfCurrentState();
        }
        return null;
    }

    public static void renderETFEmissiveModel(@NotNull Entity entity, @NotNull ResourceLocation defaultTextureOfEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, @NotNull Model model) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, model);
        }
    }

    public static void renderETFEmissiveModelPart(@NotNull Entity entity, @NotNull ResourceLocation defaultTextureOfEntity, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource vertexConsumerProvider, @NotNull ModelPart modelPart) {
        ETFTexture etfTexture = ETFManager.getInstance().getETFTexture(defaultTextureOfEntity, new ETFEntityWrapper(entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        if (etfTexture != null) {
            etfTexture.renderEmissive(matrixStack, vertexConsumerProvider, modelPart);
        }
    }

    public static ETFRandomTexturePropertyInstance readRandomPropertiesFileAndReturnTestingObject2(ResourceLocation propertiesFileIdentifier, String suffixKeyName) {
        return ETFRandomTexturePropertyInstance.getInstance(propertiesFileIdentifier, suffixKeyName);
    }

    public static class ETFRandomTexturePropertyInstance {
        private final List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> propertyCases;

        @Nullable
        private static ETFRandomTexturePropertyInstance getInstance(ResourceLocation propertiesFileIdentifier, String suffixKeyName) {
            Properties props = ETFUtils2.readAndReturnPropertiesElseNull(propertiesFileIdentifier);
            if (props == null) {
                return null;
            }
            List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> etfs = ETFTexturePropertiesUtils.getAllValidPropertyObjects(props, suffixKeyName, propertiesFileIdentifier);
            if (etfs.isEmpty()) {
                return null;
            }
            return new ETFRandomTexturePropertyInstance(etfs);
        }

        private ETFRandomTexturePropertyInstance(List<ETFTexturePropertiesUtils.ETFTexturePropertyCase> etfs) {
            this.propertyCases = etfs;
        }

        public int getSuffixForEntity(Entity entityToBeTested, boolean isThisTheFirstTestForEntity, Object2BooleanOpenHashMap<UUID> cacheToMarkEntitiesWhoseVariantCanChangeAgain) {
            boolean isAnUpdate = !isThisTheFirstTestForEntity;
            for (ETFTexturePropertiesUtils.ETFTexturePropertyCase testCase : this.propertyCases) {
                if (!testCase.doesEntityMeetConditionsOfThisCase(entityToBeTested, isThisTheFirstTestForEntity, cacheToMarkEntitiesWhoseVariantCanChangeAgain)) continue;
                return testCase.getAnEntityVariantSuffixFromThisCase(entityToBeTested.m_20148_());
            }
            return 0;
        }

        public int getSuffixForBlockEntity(BlockEntity entityToBeTested, UUID uuidForBlockEntity, boolean isThisTheFirstTestForEntity, Object2BooleanOpenHashMap<UUID> cacheToMarkEntitiesWhoseVariantCanChangeAgain) {
            boolean isAnUpdate = !isThisTheFirstTestForEntity;
            for (ETFTexturePropertiesUtils.ETFTexturePropertyCase testCase : this.propertyCases) {
                if (!testCase.doesEntityMeetConditionsOfThisCase(entityToBeTested, uuidForBlockEntity, isThisTheFirstTestForEntity, cacheToMarkEntitiesWhoseVariantCanChangeAgain)) continue;
                return testCase.getAnEntityVariantSuffixFromThisCase(uuidForBlockEntity);
            }
            return 0;
        }
    }
}

