/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.config.screens.ETFConfigScreenSkinTool;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolPixelSelection
extends ETFConfigScreen {
    private final SelectionMode MODE;
    private final ETFConfigScreenSkinTool etfParent;
    Set<Integer> selectedPixels;
    ResourceLocation currentSkinToRender = new ResourceLocation("entity_texture_features:textures/gui/icon.png");

    protected ETFConfigScreenSkinToolPixelSelection(ETFConfigScreenSkinTool parent, SelectionMode mode) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features" + (mode == SelectionMode.EMISSIVE ? ".emissive_select" : ".enchanted_select") + ".title"), parent);
        this.MODE = mode;
        this.etfParent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        ResourceLocation randomID = new ResourceLocation("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
        if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID)) {
            this.currentSkinToRender = randomID;
        }
        this.selectedPixels = new HashSet<Integer>();
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                int color = this.etfParent.currentEditorSkin.m_84985_(x, y);
                if (color == 0) continue;
                this.selectedPixels.add(color);
            }
        }
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.024), (int)((double)this.f_96544_ * 0.2), 20, 20, Component.m_130674_((String)"\u27f3"), button -> {
            this.etfParent.flipView = !this.etfParent.flipView;
        }));
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.55), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20, CommonComponents.f_130660_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)));
        int pixelSize = (int)((double)this.f_96544_ * 0.7 / 64.0);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int finalX = x;
                int finalY = y;
                Button butt = new Button((int)((double)this.f_96543_ * 0.35 + (double)(x * pixelSize)), (int)((double)this.f_96544_ * 0.2 + (double)(y * pixelSize)), pixelSize, pixelSize, Component.m_130674_((String)""), button -> {
                    int colorAtPixel = this.etfParent.currentEditorSkin.m_84985_(finalX, finalY);
                    if (this.selectedPixels.contains(colorAtPixel)) {
                        this.selectedPixels.remove(colorAtPixel);
                    } else {
                        this.selectedPixels.add(colorAtPixel);
                    }
                    this.applyCurrentSelectedPixels();
                    this.etfParent.thisETFPlayerTexture.changeSkinToThisForTool(this.etfParent.currentEditorSkin);
                    ResourceLocation randomID2 = new ResourceLocation("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
                    if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID2)) {
                        this.currentSkinToRender = randomID2;
                    }
                }, null){

                    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
                    }
                };
                this.m_142416_((GuiEventListener)butt);
            }
        }
    }

    private void applyCurrentSelectedPixels() {
        ArrayList<Integer> integerSet = new ArrayList<Integer>(this.selectedPixels);
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                if (integerSet.isEmpty()) {
                    this.etfParent.currentEditorSkin.m_84988_(x, y, 0);
                    continue;
                }
                this.etfParent.currentEditorSkin.m_84988_(x, y, integerSet.get(0).intValue());
                integerSet.remove(0);
            }
        }
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        int pixelSize = (int)((double)this.f_96544_ * 0.7 / 64.0);
        ETFConfigScreenSkinToolPixelSelection.renderGUITexture(this.currentSkinToRender, (int)((double)this.f_96543_ * 0.35), (int)((double)this.f_96544_ * 0.2), (int)((double)this.f_96543_ * 0.35 + (double)(64 * pixelSize)), (int)((double)this.f_96544_ * 0.2 + (double)(64 * pixelSize)));
        ETFConfigScreenSkinToolPixelSelection.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.skin_select" + (this.selectedPixels.size() > 64 ? ".warn" : ".hint")), (int)(this.f_96543_ / 7), (int)((int)((double)this.f_96544_ * 0.8)), (int)(this.selectedPixels.size() > 64 ? 0xFF1515 : 0xFFFFFF));
        if (Minecraft.m_91087_() != null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                int blinkModifierBySystemTimeInTicks = (int)(System.currentTimeMillis() / 50L % (long)(30 + ETFClientCommon.ETFConfigData.blinkLength * 2));
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)player.m_20148_(), player.f_19853_.m_46467_() + (long)blinkModifierBySystemTimeInTicks - (long)(15 + ETFClientCommon.ETFConfigData.blinkLength));
                int height = (int)((double)this.f_96544_ * 0.75);
                int playerX = (int)((double)this.f_96543_ * 0.14);
                this.drawEntity(playerX, height, (int)((double)this.f_96544_ * 0.3), -mouseX + playerX, (float)((double)(-mouseY) + (double)this.f_96544_ * 0.3), (LivingEntity)player);
            } else {
                ETFConfigScreenSkinToolPixelSelection.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)Component.m_130674_((String)"Player model only visible while in game!"), (int)(this.f_96543_ / 7), (int)((int)((double)this.f_96544_ * 0.4)), (int)0xFFFFFF);
                ETFConfigScreenSkinToolPixelSelection.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)Component.m_130674_((String)"load a single-player world and then open this menu."), (int)(this.f_96543_ / 7), (int)((int)((double)this.f_96544_ * 0.45)), (int)0xFFFFFF);
            }
        }
    }

    public void drawEntity(int x, int y, int size, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        PoseStack matrixStack = RenderSystem.m_157191_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 1050.0);
        matrixStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack matrixStack2 = new PoseStack();
        matrixStack2.m_85837_(0.0, 0.0, 1000.0);
        matrixStack2.m_85841_((float)size, (float)size, (float)size);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion2 = Vector3f.f_122223_.m_122240_(g * 20.0f);
        quaternion.m_80148_(quaternion2);
        matrixStack2.m_85845_(quaternion);
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = (this.etfParent.flipView ? 0.0f : 180.0f) + f * 20.0f;
        entity.m_146922_((this.etfParent.flipView ? 0.0f : 180.0f) + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.m_80157_();
        entityRenderDispatcher.m_114412_(quaternion2);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (MultiBufferSource)immediate, 0x800080));
        immediate.m_109911_();
        MultiBufferSource.BufferSource immediate2 = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> {
            EntityRenderer bob;
            RenderType layer;
            VertexConsumer vertexC;
            ResourceLocation emissive;
            if (this.etfParent.thisETFPlayerTexture != null && this.etfParent.thisETFPlayerTexture.etfTextureOfFinalBaseSkin != null && entity instanceof AbstractClientPlayer && (emissive = this.etfParent.thisETFPlayerTexture.etfTextureOfFinalBaseSkin.getEmissiveIdentifierOfCurrentState()) != null && (vertexC = immediate.m_6299_(layer = RenderType.m_110473_((ResourceLocation)emissive))) != null && (bob = entityRenderDispatcher.m_114382_((Entity)entity)) instanceof LivingEntityRenderer) {
                ((LivingEntityRenderer)bob).m_7200_().m_7695_(matrixStack, vertexC, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
        immediate2.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public static enum SelectionMode {
        EMISSIVE(56, 16),
        ENCHANTED(56, 24);

        final int startX;
        final int startY;

        private SelectionMode(int start_x, int start_y) {
            this.startX = start_x;
            this.startY = start_y;
        }
    }
}

