/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.config.screens.ETFConfigScreenMain;

public class ETFConfigScreenWarnings
extends ETFConfigScreen {
    final ObjectOpenHashSet<ConfigWarning> warningsFound;

    protected ETFConfigScreenWarnings(Screen parent, ObjectOpenHashSet<ConfigWarning> warningsFound) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.warnings.title"), parent);
        this.warningsFound = warningsFound;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.55), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20, CommonComponents.f_130660_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)));
        this.m_142416_((GuiEventListener)this.getETFButton((int)((double)this.f_96543_ * 0.25), (int)((double)this.f_96544_ * 0.9), (int)((double)this.f_96543_ * 0.2), 20, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.ignore_all"), button -> {
            ETFConfigScreenMain.temporaryETFConfig.ignoredConfigs.addAll(List.of(ConfigWarning.values()));
            this.m_232761_();
        }));
        double offset = 0.0;
        if (ETFClientCommon.configHadLoadError) {
            offset = 0.1;
        }
        for (ConfigWarning warning : this.warningsFound) {
            if (warning.showDisableButton) {
                Button butt = this.getETFButton((int)((double)this.f_96543_ * 0.75), (int)((double)this.f_96544_ * (0.25 + offset)), (int)((double)this.f_96543_ * 0.17), 20, Component.m_130674_((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.warn.ignore").getString() + (ETFConfigScreenMain.temporaryETFConfig.ignoredConfigs.contains((Object)warning) ? CommonComponents.f_130657_ : CommonComponents.f_130658_).getString())), button -> {
                    if (ETFConfigScreenMain.temporaryETFConfig.ignoredConfigs.contains((Object)warning)) {
                        ETFConfigScreenMain.temporaryETFConfig.ignoredConfigs.remove((Object)warning);
                    } else {
                        ETFConfigScreenMain.temporaryETFConfig.ignoredConfigs.add(warning);
                    }
                    button.m_93666_(Component.m_130674_((String)(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.warn.ignore").getString() + (ETFConfigScreenMain.temporaryETFConfig.ignoredConfigs.contains((Object)warning) ? CommonComponents.f_130657_ : CommonComponents.f_130658_).getString())));
                }, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.ignore_description"));
                this.m_142416_((GuiEventListener)butt);
            }
            offset += 0.1;
        }
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6305_(matrices, mouseX, mouseY, delta);
        ETFConfigScreenWarnings.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.warn_instruction"), (int)((int)((double)this.f_96543_ * 0.5)), (int)((int)((double)this.f_96544_ * 0.18)), (int)0xFFFFFF);
        double offset = 0.0;
        if (ETFClientCommon.configHadLoadError) {
            ETFConfigScreenWarnings.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.warn_config_load"), (int)((int)((double)this.f_96543_ * 0.5)), (int)((int)((double)this.f_96544_ * 0.28)), (int)11546150);
            offset = 0.1;
        }
        for (ConfigWarning warning : this.warningsFound) {
            ETFConfigScreenWarnings.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)ETFVersionDifferenceHandler.getTextFromTranslation(warning.text_translation_key), (int)((int)((double)this.f_96543_ * 0.05)), (int)((int)((double)this.f_96544_ * (0.25 + offset))), (int)0xFFFFFF);
            ETFConfigScreenWarnings.m_93243_((PoseStack)matrices, (Font)this.f_96547_, (Component)ETFVersionDifferenceHandler.getTextFromTranslation(warning.text2_translation_key), (int)((int)((double)this.f_96543_ * 0.05)), (int)((int)((double)this.f_96544_ * (0.29 + offset))), (int)0x888888);
            offset += 0.1;
        }
    }

    public static enum ConfigWarning {
        FIGURA(true, "figura", "config.entity_texture_features.warn.figura.text.1", "config.entity_texture_features.warn.figura.text.2"),
        ENHANCED_BLOCK_ENTITIES(false, "enhancedblockentities", "config.entity_texture_features.warn.ebe.text.1", "config.entity_texture_features.warn.ebe.text.2"),
        QUARK(false, "quark", "config.entity_texture_features.warn.quark.text.3", "config.entity_texture_features.warn.quark.text.4"),
        IRIS(false, "iris", "config.entity_texture_features.warn.iris.text.1", "config.entity_texture_features.warn.iris.text.2"),
        IRIS_AND_3D_SKIN_trim_warn(false, () -> ETFVersionDifferenceHandler.isThisModLoaded("iris") && ETFClientCommon.SKIN_LAYERS_DETECTED, "config.entity_texture_features.warn.iris_3d.text.1", "config.entity_texture_features.warn.iris_3d.text.2"),
        NO_CEM(false, () -> !ETFVersionDifferenceHandler.isThisModLoaded("entity_model_features") && !ETFVersionDifferenceHandler.isThisModLoaded("cem"), "config.entity_texture_features.warn.no_emf.text.1", "config.entity_texture_features.warn.no_emf.text.2");

        public final boolean showDisableButton;
        private final Supplier<Boolean> condition;
        private final String text_translation_key;
        private final String text2_translation_key;

        private ConfigWarning(boolean showDisableButton, Supplier<Boolean> condition, String text_translation_key, String text2_translation_key) {
            this.showDisableButton = showDisableButton;
            this.condition = condition;
            this.text_translation_key = text_translation_key;
            this.text2_translation_key = text2_translation_key;
        }

        private ConfigWarning(boolean showDisableButton, String modName, String text_translation_key, String text2_translation_key) {
            this.showDisableButton = showDisableButton;
            this.condition = () -> ETFVersionDifferenceHandler.isThisModLoaded(modName);
            this.text_translation_key = text_translation_key;
            this.text2_translation_key = text2_translation_key;
        }

        public boolean isConditionMet() {
            return this.condition.get();
        }
    }
}

