/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.block_entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.entity_handlers.ETFBlockEntityWrapper;
import traben.entity_texture_features.entity_handlers.ETFEntity;
import traben.entity_texture_features.entity_handlers.ETFPlayerHeadWrapper;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFPlayerTexture;
import traben.entity_texture_features.texture_handlers.ETFTexture;

@Mixin(value={SkullBlockRenderer.class})
public abstract class MixinSkullBlockEntityRenderer
implements BlockEntityRenderer<BedBlockEntity> {
    @Shadow
    @Final
    private static Map<SkullBlock.Type, ResourceLocation> f_112519_;
    private ETFTexture thisETFTexture = null;
    private ETFPlayerTexture thisETFPlayerTexture = null;
    private ETFEntity etf$entity = null;

    @Inject(method={"render(Lnet/minecraft/block/entity/SkullBlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/block/entity/SkullBlockEntityRenderer;getRenderLayer(Lnet/minecraft/block/SkullBlock$SkullType;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/client/render/RenderLayer;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void etf$alterTexture(SkullBlockEntity skullBlockEntity, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j, CallbackInfo ci, float g, BlockState blockState, boolean bl, Direction direction, float h, SkullBlock.Type skullType, SkullModelBase skullBlockEntityModel) {
        this.thisETFTexture = null;
        this.thisETFPlayerTexture = null;
        this.etf$entity = null;
        if (ETFClientCommon.ETFConfigData.enableCustomTextures && ETFClientCommon.ETFConfigData.enableCustomBlockEntities && ETFClientCommon.ETFConfigData.skinFeaturesEnabled) {
            Level worldCheck = skullBlockEntity.m_58904_();
            if (worldCheck == null) {
                worldCheck = Minecraft.m_91087_().f_91073_;
            }
            if (worldCheck != null) {
                boolean player;
                String uuidBytes = "skull" + skullBlockEntity.m_58899_().toString() + (direction == null ? "*" : direction.toString()) + bl + skullType.toString();
                ResourceLocation identifier = MixinSkullBlockEntityRenderer.etf$getIdentifier(skullType, skullBlockEntity.m_59779_());
                boolean bl2 = player = skullBlockEntity.m_59779_() != null;
                if (player) {
                    uuidBytes = uuidBytes + skullBlockEntity.m_59779_().getId();
                    UUID uuid = UUID.nameUUIDFromBytes(uuidBytes.getBytes());
                    ETFPlayerHeadWrapper etfPlayer = new ETFPlayerHeadWrapper((BlockEntity)skullBlockEntity, uuid);
                    this.etf$entity = etfPlayer;
                    this.thisETFPlayerTexture = ETFManager.getInstance().getPlayerTexture(etfPlayer, identifier);
                } else {
                    UUID uuid = UUID.nameUUIDFromBytes(uuidBytes.getBytes());
                    this.etf$entity = new ETFBlockEntityWrapper((BlockEntity)skullBlockEntity, uuid);
                    this.thisETFTexture = ETFManager.getInstance().getETFTexture(identifier, this.etf$entity, ETFManager.TextureSource.BLOCK_ENTITY, true);
                }
            }
        }
    }

    @Inject(method={"render(Lnet/minecraft/block/entity/SkullBlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void etf$renderFeatures(SkullBlockEntity skullBlockEntity, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j, CallbackInfo ci, float g, BlockState blockState, boolean bl, Direction direction, float h, SkullBlock.Type skullType, SkullModelBase skullBlockEntityModel, RenderType renderLayer) {
        if (ETFClientCommon.ETFConfigData.enableEmissiveBlockEntities && ETFClientCommon.ETFConfigData.skinFeaturesEnabled) {
            matrixStack.m_85836_();
            if (direction == null) {
                matrixStack.m_85837_(0.5, 0.0, 0.5);
            } else {
                matrixStack.m_85837_((double)(0.5f - (float)direction.m_122429_() * 0.25f), 0.25, (double)(0.5f - (float)direction.m_122431_() * 0.25f));
            }
            matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
            skullBlockEntityModel.m_6251_(g, h, 0.0f);
            if (this.thisETFTexture != null) {
                this.thisETFTexture.renderEmissive(matrixStack, vertexConsumerProvider, (Model)skullBlockEntityModel, ETFManager.EmissiveRenderModes.DULL);
            } else if (this.thisETFPlayerTexture != null) {
                this.thisETFPlayerTexture.renderFeatures(matrixStack, vertexConsumerProvider, i, skullBlockEntityModel);
            }
            matrixStack.m_85849_();
        }
    }

    @ModifyArg(method={"render(Lnet/minecraft/block/entity/SkullBlockEntity;FLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/block/entity/SkullBlockEntityRenderer;renderSkull(Lnet/minecraft/util/math/Direction;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/block/entity/SkullBlockEntityModel;Lnet/minecraft/client/render/RenderLayer;)V"), index=7)
    private RenderType etf$modifyRenderLayer(RenderType renderLayer) {
        ResourceLocation skin;
        if (this.thisETFTexture != null) {
            return RenderType.m_110464_((ResourceLocation)this.thisETFTexture.getTextureIdentifier(this.etf$entity));
        }
        if (this.thisETFPlayerTexture != null && (skin = this.thisETFPlayerTexture.getBaseHeadTextureIdentifierOrNullForVanilla()) != null) {
            return RenderType.m_110473_((ResourceLocation)skin);
        }
        return renderLayer;
    }

    private static ResourceLocation etf$getIdentifier(SkullBlock.Type type, @Nullable GameProfile profile) {
        ResourceLocation identifier = f_112519_.get(type);
        if (type == SkullBlock.Types.PLAYER && profile != null) {
            Minecraft minecraftClient = Minecraft.m_91087_();
            Map map = minecraftClient.m_91109_().m_118815_(profile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraftClient.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)profile));
        }
        return identifier;
    }
}

