/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.misc;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFPlayerTexture;

@Mixin(value={AbstractClientPlayer.class})
public abstract class MixinAbstractClientPlayerEntity
extends Player {
    public MixinAbstractClientPlayerEntity(Level world, BlockPos pos, float yaw, GameProfile gameProfile, @Nullable ProfilePublicKey publicKey) {
        super(world, pos, yaw, gameProfile, publicKey);
    }

    @Shadow
    public abstract ResourceLocation m_108560_();

    @Inject(method={"getCapeTexture"}, at={@At(value="RETURN")}, cancellable=true)
    private void changeCapeReturnsToNotNull(CallbackInfoReturnable<ResourceLocation> cir) {
        ResourceLocation cape = (ResourceLocation)cir.getReturnValue();
        if (cape != null && cape.toString().contains("/cit/")) {
            return;
        }
        ETFPlayerTexture textureData = ETFManager.getInstance().getPlayerTexture(this, this.m_108560_());
        if (textureData != null && textureData.hasCustomCape()) {
            cir.setReturnValue((Object)textureData.etfCapeIdentifier);
        } else if (this.m_20148_().equals(ETFPlayerTexture.Dev)) {
            cir.setReturnValue((Object)new ResourceLocation("entity_texture_features", "textures/capes/etf.png"));
        } else if (this.m_20148_().equals(ETFPlayerTexture.Wife)) {
            cir.setReturnValue((Object)new ResourceLocation("entity_texture_features", "textures/capes/wife.png"));
        }
    }

    @Inject(method={"canRenderCapeTexture"}, at={@At(value="RETURN")}, cancellable=true)
    private void changeCapeReturnsBoolean(CallbackInfoReturnable<Boolean> cir) {
        ETFPlayerTexture textureData = ETFManager.getInstance().getPlayerTexture(this, this.m_108560_());
        if (textureData != null && textureData.hasCustomCape() || this.m_20148_().equals(ETFPlayerTexture.Dev) || this.m_20148_().equals(ETFPlayerTexture.Wife)) {
            cir.setReturnValue((Object)true);
        }
    }
}

