/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.entity_handlers.ETFEntityWrapper;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={BoatRenderer.class})
public abstract class MixinBoatEntityRenderer
extends EntityRenderer<Boat> {
    private ETFEntityWrapper etf$entity = null;
    private ResourceLocation etf$identifier = null;
    @Final
    @Shadow
    private Map<Boat.Type, Pair<ResourceLocation, ListModel<Boat>>> f_173934_;

    @Shadow
    public abstract ResourceLocation m_5478_(Boat var1);

    protected MixinBoatEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"render(Lnet/minecraft/entity/vehicle/BoatEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="HEAD")})
    private void etf$getEntity(Boat boatEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo ci) {
        this.etf$entity = new ETFEntityWrapper((Entity)boatEntity);
        this.etf$identifier = this.m_5478_(boatEntity);
    }

    @ModifyArg(method={"render(Lnet/minecraft/entity/vehicle/BoatEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;"))
    private RenderType etf$returnAlteredTexture(RenderType renderLayer) {
        if (ETFClientCommon.ETFConfigData.enableCustomTextures && !renderLayer.equals(RenderType.m_110478_())) {
            try {
                if (this.etf$identifier != null) {
                    RenderType layerToReturn;
                    ResourceLocation alteredTexture = ETFManager.getInstance().getETFTexture(this.etf$identifier, this.etf$entity, ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs).getTextureIdentifier(this.etf$entity);
                    if (ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.containsKey(this.etf$entity.getType())) {
                        int choice = ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.getInt(this.etf$entity.getType());
                        switch (choice) {
                            case 1: {
                                layerToReturn = RenderType.m_110473_((ResourceLocation)alteredTexture);
                                break;
                            }
                            case 2: {
                                layerToReturn = RenderType.m_110470_((ResourceLocation)alteredTexture);
                                break;
                            }
                            case 3: {
                                layerToReturn = RenderType.m_173242_();
                                break;
                            }
                            case 4: {
                                layerToReturn = RenderType.m_110491_((ResourceLocation)alteredTexture);
                                break;
                            }
                            default: {
                                layerToReturn = null;
                                break;
                            }
                        }
                    } else {
                        layerToReturn = RenderType.m_110458_((ResourceLocation)alteredTexture);
                    }
                    if (layerToReturn != null) {
                        return layerToReturn;
                    }
                }
            }
            catch (Exception e) {
                ETFUtils2.logError(e.toString(), false);
            }
        }
        return renderLayer;
    }

    @Inject(method={"render(Lnet/minecraft/entity/vehicle/BoatEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/BoatEntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void etf$applyEmissive(Boat boatEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo ci, float h, float j, float k, Pair pair, ResourceLocation identifier, BoatModel boatEntityModel, VertexConsumer vertexConsumer) {
        ETFManager.getInstance().getETFTexture(this.etf$identifier, this.etf$entity, ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs).renderEmissive(matrixStack, vertexConsumerProvider, (Model)boatEntityModel);
    }
}

