/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.entity_handlers.ETFEntityWrapper;
import traben.entity_texture_features.mod_compat.ETF3DSkinLayersUtil;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFPlayerTexture;
import traben.entity_texture_features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={LivingEntityRenderer.class})
public abstract class MixinLivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    @Unique
    private ETFTexture thisETF$Texture = null;
    @Unique
    private ETFPlayerTexture thisETF$PlayerTexture = null;
    @Unique
    private T etf$thisEntity = null;
    @Unique
    private ResourceLocation etf$thisIdentifier = null;

    protected MixinLivingEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Shadow
    public abstract M m_7200_();

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V", shift=At.Shift.AFTER)})
    private void etf$applyRenderFeatures(T livingEntity, float a, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo ci) {
        if (livingEntity instanceof Player) {
            if (ETFClientCommon.ETFConfigData.skinFeaturesEnabled && this.thisETF$PlayerTexture != null) {
                this.thisETF$PlayerTexture.renderFeatures(matrixStack, vertexConsumerProvider, i, this.m_7200_());
            }
        } else if (this.thisETF$Texture != null) {
            this.thisETF$Texture.renderEmissive(matrixStack, vertexConsumerProvider, (Model)this.m_7200_());
        }
    }

    @Inject(method={"getRenderLayer"}, at={@At(value="HEAD")})
    private void etf$getEntityParameter(T entity, boolean showBody, boolean translucent, boolean showOutline, CallbackInfoReturnable<RenderType> cir) {
        this.etf$thisEntity = entity;
    }

    @ModifyArg(method={"getRenderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/RenderLayer;getItemEntityTranslucentCull(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
    private ResourceLocation etf$changeFirstPossibility(ResourceLocation texture) {
        return this.etf$getAndSetTexture(this.etf$thisEntity, texture);
    }

    @ModifyArg(method={"getRenderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;getLayer(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
    private ResourceLocation etf$changeSecondPossiblility(ResourceLocation texture) {
        return this.etf$getAndSetTexture(this.etf$thisEntity, texture);
    }

    @ModifyArg(method={"getRenderLayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/RenderLayer;getOutline(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"))
    private ResourceLocation etf$changeThirdPossiblility(ResourceLocation texture) {
        return this.etf$getAndSetTexture(this.etf$thisEntity, texture);
    }

    @Unique
    private ResourceLocation etf$getAndSetTexture(T entity, ResourceLocation vanillaTexture) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (ETFClientCommon.ETFConfigData.skinFeaturesEnabled) {
                this.thisETF$PlayerTexture = ETFManager.getInstance().getPlayerTexture(player, ((AbstractClientPlayer)player).m_108560_());
                if (this.thisETF$PlayerTexture != null) {
                    ResourceLocation etfTexture = this.thisETF$PlayerTexture.getBaseTextureIdentifierOrNullForVanilla(player);
                    this.etf$thisIdentifier = etfTexture == null ? vanillaTexture : etfTexture;
                    return this.etf$thisIdentifier;
                }
            }
            if (!("minecraft:texture/entity/steve.png".equals(vanillaTexture.toString()) || "minecraft:texture/entity/alex.png".equals(vanillaTexture.toString()) || vanillaTexture.toString().contains("minecraft:texture/entity/player/"))) {
                this.etf$thisIdentifier = vanillaTexture;
                return this.etf$thisIdentifier;
            }
        }
        this.thisETF$Texture = ETFManager.getInstance().getETFTexture(vanillaTexture, new ETFEntityWrapper((Entity)entity), ETFManager.TextureSource.ENTITY, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs);
        this.etf$thisIdentifier = this.thisETF$Texture.getTextureIdentifier(new ETFEntityWrapper((Entity)entity));
        return this.etf$thisIdentifier;
    }

    @Inject(method={"Lnet/minecraft/client/render/entity/LivingEntityRenderer;getRenderLayer(Lnet/minecraft/entity/LivingEntity;ZZZ)Lnet/minecraft/client/render/RenderLayer;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void etf$renderLayerModify(T entity, boolean showBody, boolean translucent, boolean showOutline, CallbackInfoReturnable<RenderType> cir) {
        if (!translucent && showBody && ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.containsKey((Object)entity.m_6095_())) {
            int choice = ETFManager.getInstance().ENTITY_TYPE_RENDER_LAYER.getInt((Object)entity.m_6095_());
            switch (choice) {
                case 1: {
                    cir.setReturnValue((Object)RenderType.m_110473_((ResourceLocation)this.etf$thisIdentifier));
                    break;
                }
                case 2: {
                    cir.setReturnValue((Object)RenderType.m_110470_((ResourceLocation)this.etf$thisIdentifier));
                    break;
                }
                case 3: {
                    cir.setReturnValue((Object)RenderType.m_173242_());
                    break;
                }
                case 4: {
                    cir.setReturnValue((Object)RenderType.m_110491_((ResourceLocation)this.etf$thisIdentifier));
                    break;
                }
                default: {
                    cir.setReturnValue((Object)((RenderType)cir.getReturnValue()));
                    break;
                }
            }
        } else {
            cir.setReturnValue((Object)((RenderType)cir.getReturnValue()));
        }
    }

    @ModifyArg(method={"addFeature"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"), index=0)
    private Object etf$3dSkinLayerCompat(Object featureRenderer) {
        try {
            if (ETFClientCommon.SKIN_LAYERS_DETECTED && ETFClientCommon.ETFConfigData.use3DSkinLayerPatch && ETF3DSkinLayersUtil.canReplace((RenderLayer)featureRenderer)) {
                return ETF3DSkinLayersUtil.getReplacement((RenderLayer)featureRenderer, this);
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Exception with ETF's 3D skin layers mod compatibility: " + e);
        }
        catch (NoClassDefFoundError error) {
            ETFUtils2.logError("Error with ETF's 3D skin layers mod compatibility: " + error);
        }
        return featureRenderer;
    }
}

