/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.BlockAndTintGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.entity_handlers.ETFEntityWrapper;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFSprite;
import traben.entity_texture_features.texture_handlers.ETFTexture;

@Mixin(value={PaintingRenderer.class})
public abstract class MixinPaintingEntityRenderer
extends EntityRenderer<Painting> {
    @Unique
    private static final ResourceLocation etf$BACK_SPRITE_ID = new ResourceLocation("textures/painting/back.png");

    @Shadow
    protected abstract void m_115536_(Matrix4f var1, Matrix3f var2, VertexConsumer var3, float var4, float var5, float var6, float var7, float var8, int var9, int var10, int var11, int var12);

    protected MixinPaintingEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"render(Lnet/minecraft/entity/decoration/painting/PaintingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void etf$getSprites(Painting paintingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo ci) {
        try {
            TextureAtlasSprite paintingSprite = Minecraft.m_91087_().m_91305_().m_235033_((PaintingVariant)paintingEntity.m_218901_().m_203334_());
            ResourceLocation paintingId = paintingSprite.m_118413_();
            ResourceLocation paintingTexture = new ResourceLocation(paintingId.m_135827_(), "textures/" + paintingId.m_135815_() + ".png");
            ETFEntityWrapper etfEntity = new ETFEntityWrapper((Entity)paintingEntity);
            ETFTexture frontTexture = ETFManager.getInstance().getETFTexture(paintingTexture, etfEntity, ETFManager.TextureSource.ENTITY, false);
            ETFSprite etf$Sprite = frontTexture.getSprite(paintingSprite);
            ETFTexture backTexture = ETFManager.getInstance().getETFTexture(etf$BACK_SPRITE_ID, etfEntity, ETFManager.TextureSource.ENTITY, false);
            ETFSprite etf$BackSprite = backTexture.getSprite(Minecraft.m_91087_().m_91305_().m_118806_());
            if (etf$Sprite.isETFAltered || etf$Sprite.isEmissive() || etf$BackSprite.isETFAltered || etf$BackSprite.isEmissive()) {
                matrixStack.m_85836_();
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - f));
                PaintingVariant paintingVariant = (PaintingVariant)paintingEntity.m_218901_().m_203334_();
                matrixStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
                this.etf$renderETFPainting(matrixStack, vertexConsumerProvider, paintingEntity, paintingVariant.m_218908_(), paintingVariant.m_218909_(), etf$Sprite, etf$BackSprite);
                matrixStack.m_85849_();
                super.m_7392_((Entity)paintingEntity, f, g, matrixStack, vertexConsumerProvider, i);
                ci.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void etf$renderETFPainting(PoseStack matrices, MultiBufferSource vertexConsumerProvider, Painting entity, int width, int height, ETFSprite ETFPaintingSprite, ETFSprite ETFBackSprite) {
        VertexConsumer vertexConsumerFront = vertexConsumerProvider.m_6299_(RenderType.m_110446_((ResourceLocation)ETFPaintingSprite.getSpriteVariant().m_118414_().m_118330_()));
        this.etf$renderETFPaintingFront(matrices, vertexConsumerFront, entity, width, height, ETFPaintingSprite.getSpriteVariant(), false);
        VertexConsumer vertexConsumerBack = vertexConsumerProvider.m_6299_(RenderType.m_110446_((ResourceLocation)ETFBackSprite.getSpriteVariant().m_118414_().m_118330_()));
        this.etf$renderETFPaintingBack(matrices, vertexConsumerBack, entity, width, height, ETFBackSprite.getSpriteVariant(), false);
        if (ETFPaintingSprite.isEmissive()) {
            vertexConsumerFront = vertexConsumerProvider.m_6299_(RenderType.m_110470_((ResourceLocation)ETFPaintingSprite.getEmissive().m_118414_().m_118330_()));
            this.etf$renderETFPaintingFront(matrices, vertexConsumerFront, entity, width, height, ETFPaintingSprite.getEmissive(), true);
        }
        if (ETFBackSprite.isEmissive()) {
            vertexConsumerFront = vertexConsumerProvider.m_6299_(RenderType.m_110470_((ResourceLocation)ETFBackSprite.getEmissive().m_118414_().m_118330_()));
            this.etf$renderETFPaintingBack(matrices, vertexConsumerFront, entity, width, height, ETFBackSprite.getEmissive(), true);
        }
    }

    @Unique
    private void etf$renderETFPaintingFront(PoseStack matrices, VertexConsumer vertexConsumerFront, Painting entity, int width, int height, TextureAtlasSprite paintingSprite, boolean emissive) {
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_85861_();
        Matrix3f matrix3f = entry.m_85864_();
        float f = (float)(-width) / 2.0f;
        float g = (float)(-height) / 2.0f;
        int u = width / 16;
        int v = height / 16;
        double d = 16.0 / (double)u;
        double e = 16.0 / (double)v;
        for (int w = 0; w < u; ++w) {
            for (int x = 0; x < v; ++x) {
                int light;
                float y = f + (float)((w + 1) * 16);
                float z = f + (float)(w * 16);
                float aa = g + (float)((x + 1) * 16);
                float ab = g + (float)(x * 16);
                if (emissive) {
                    light = 0xF000F2;
                } else {
                    int ac = entity.m_146903_();
                    int ad = Mth.m_14107_((double)(entity.m_20186_() + (double)((aa + ab) / 2.0f / 16.0f)));
                    int ae = entity.m_146907_();
                    Direction direction = entity.m_6350_();
                    if (direction == Direction.NORTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() + (double)((y + z) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.WEST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() - (double)((y + z) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.SOUTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() - (double)((y + z) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.EAST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() + (double)((y + z) / 2.0f / 16.0f)));
                    }
                    light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)new BlockPos(ac, ad, ae));
                }
                float ag = paintingSprite.m_118367_(d * (double)(u - w));
                float ah = paintingSprite.m_118367_(d * (double)(u - (w + 1)));
                float ai = paintingSprite.m_118393_(e * (double)(v - x));
                float aj = paintingSprite.m_118393_(e * (double)(v - (x + 1)));
                this.m_115536_(matrix4f, matrix3f, vertexConsumerFront, y, ab, ah, ai, -0.5f, 0, 0, -1, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerFront, z, ab, ag, ai, -0.5f, 0, 0, -1, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerFront, z, aa, ag, aj, -0.5f, 0, 0, -1, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerFront, y, aa, ah, aj, -0.5f, 0, 0, -1, light);
            }
        }
    }

    @Unique
    private void etf$renderETFPaintingBack(PoseStack matrices, VertexConsumer vertexConsumerBack, Painting entity, int width, int height, TextureAtlasSprite backSprite, boolean emissive) {
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_85861_();
        Matrix3f matrix3f = entry.m_85864_();
        float f = (float)(-width) / 2.0f;
        float g = (float)(-height) / 2.0f;
        float i = backSprite.m_118409_();
        float j = backSprite.m_118410_();
        float k = backSprite.m_118411_();
        float l = backSprite.m_118412_();
        float m = backSprite.m_118409_();
        float n = backSprite.m_118410_();
        float o = backSprite.m_118411_();
        float p = backSprite.m_118393_(1.0);
        float q = backSprite.m_118409_();
        float r = backSprite.m_118367_(1.0);
        float s = backSprite.m_118411_();
        float t = backSprite.m_118412_();
        int u = width / 16;
        int v = height / 16;
        for (int w = 0; w < u; ++w) {
            for (int x = 0; x < v; ++x) {
                int light;
                float y = f + (float)((w + 1) * 16);
                float z = f + (float)(w * 16);
                float aa = g + (float)((x + 1) * 16);
                float ab = g + (float)(x * 16);
                if (emissive) {
                    light = 0xF000F2;
                } else {
                    int ac = entity.m_146903_();
                    int ad = Mth.m_14107_((double)(entity.m_20186_() + (double)((aa + ab) / 2.0f / 16.0f)));
                    int ae = entity.m_146907_();
                    Direction direction = entity.m_6350_();
                    if (direction == Direction.NORTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() + (double)((y + z) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.WEST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() - (double)((y + z) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.SOUTH) {
                        ac = Mth.m_14107_((double)(entity.m_20185_() - (double)((y + z) / 2.0f / 16.0f)));
                    }
                    if (direction == Direction.EAST) {
                        ae = Mth.m_14107_((double)(entity.m_20189_() + (double)((y + z) / 2.0f / 16.0f)));
                    }
                    light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)new BlockPos(ac, ad, ae));
                }
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, aa, j, k, 0.5f, 0, 0, 1, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, aa, i, k, 0.5f, 0, 0, 1, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, ab, i, l, 0.5f, 0, 0, 1, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, ab, j, l, 0.5f, 0, 0, 1, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, aa, m, o, -0.5f, 0, 1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, aa, n, o, -0.5f, 0, 1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, aa, n, p, 0.5f, 0, 1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, aa, m, p, 0.5f, 0, 1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, ab, m, o, 0.5f, 0, -1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, ab, n, o, 0.5f, 0, -1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, ab, n, p, -0.5f, 0, -1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, ab, m, p, -0.5f, 0, -1, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, aa, r, s, 0.5f, -1, 0, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, ab, r, t, 0.5f, -1, 0, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, ab, q, t, -0.5f, -1, 0, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, y, aa, q, s, -0.5f, -1, 0, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, aa, r, s, -0.5f, 1, 0, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, ab, r, t, -0.5f, 1, 0, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, ab, q, t, 0.5f, 1, 0, 0, light);
                this.m_115536_(matrix4f, matrix3f, vertexConsumerBack, z, aa, q, s, 0.5f, 1, 0, 0, light);
            }
        }
    }
}

