/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.entity.renderer.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Spider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.entity_handlers.ETFEntityWrapper;
import traben.entity_texture_features.texture_handlers.ETFManager;

@Mixin(value={EyesLayer.class})
public abstract class MixinEyesFeatureRenderer<T extends Entity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @Unique
    private RenderType etf$eyesRenderLayer = null;

    public MixinEyesFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    @ModifyConstant(method={"render"}, constant={@Constant(intValue=0xF00000)})
    private int etf$markLightValueForEMF(int value) {
        return 0xF000F1;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void etf$mixin(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        this.etf$eyesRenderLayer = null;
        if (ETFClientCommon.ETFConfigData.enableCustomTextures) {
            if (entity instanceof EnderMan) {
                this.etf$setEyes("textures/entity/enderman/enderman_eyes.png", entity);
            } else if (entity instanceof Spider) {
                this.etf$setEyes("textures/entity/spider_eyes.png", entity);
            } else if (entity instanceof Phantom) {
                this.etf$setEyes("textures/entity/phantom_eyes.png", entity);
            }
        }
    }

    @Unique
    private void etf$setEyes(String texture, T entity) {
        ResourceLocation textureId = new ResourceLocation(texture);
        ResourceLocation altered = ETFManager.getInstance().getETFTexture(textureId, new ETFEntityWrapper((Entity)entity), ETFManager.TextureSource.ENTITY_FEATURE, ETFClientCommon.ETFConfigData.removePixelsUnderEmissiveMobs).getTextureIdentifier(new ETFEntityWrapper((Entity)entity));
        if (!altered.equals((Object)textureId)) {
            this.etf$eyesRenderLayer = RenderType.m_110488_((ResourceLocation)altered);
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;"), index=0)
    private RenderType etf$modifyRenderLayer(RenderType layer) {
        if (this.etf$eyesRenderLayer != null) {
            return this.etf$eyesRenderLayer;
        }
        return layer;
    }
}

