/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mod_compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.renderlayers.BodyLayerFeatureRenderer;
import dev.tr7zw.skinlayers.renderlayers.HeadLayerFeatureRenderer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.player.PlayerModelPart;
import traben.entity_texture_features.mod_compat.ETF3DBodyLayerFeatureRenderer;
import traben.entity_texture_features.mod_compat.ETF3DHeadLayerFeatureRenderer;
import traben.entity_texture_features.utils.ETFUtils2;

public abstract class ETF3DSkinLayersUtil {
    public static boolean canReplace(RenderLayer<?, ?> feature) {
        return feature instanceof BodyLayerFeatureRenderer || feature instanceof HeadLayerFeatureRenderer;
    }

    public static RenderLayer<?, ?> getReplacement(RenderLayer<?, ?> feature, RenderLayerParent<?, ?> context) {
        try {
            if (feature instanceof HeadLayerFeatureRenderer) {
                return new ETF3DHeadLayerFeatureRenderer(context);
            }
            if (feature instanceof BodyLayerFeatureRenderer) {
                return new ETF3DBodyLayerFeatureRenderer(context);
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Exception with ETF's 3D skin layers mod compatibility: " + e);
        }
        ETFUtils2.logError("Failed in ETF's 3D skin layers mod compatibility.");
        return feature;
    }

    public static void renderHand(PlayerRenderer instance, PoseStack poseStack, VertexConsumer vertexConsumer, int i, AbstractClientPlayer abstractClientPlayer, ModelPart arm, ModelPart sleeve) {
        try {
            boolean rightSleeve;
            boolean bl = rightSleeve = ((PlayerModel)instance.m_7200_()).f_103374_ != sleeve;
            if (rightSleeve ? !SkinLayersModBase.config.enableRightSleeve : !SkinLayersModBase.config.enableLeftSleeve) {
                return;
            }
            sleeve.f_104207_ = false;
            if (abstractClientPlayer.m_36170_(rightSleeve ? PlayerModelPart.RIGHT_SLEEVE : PlayerModelPart.LEFT_SLEEVE)) {
                PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
                float pixelScaling = 1.1f;
                float armHeightScaling = 1.1f;
                boolean thinArms = ((PlayerEntityModelAccessor)instance.m_7200_()).hasThinArms();
                if (SkinUtil.setup3dLayers((AbstractClientPlayer)abstractClientPlayer, (PlayerSettings)settings, (boolean)thinArms, (PlayerModel)((PlayerModel)instance.m_7200_()))) {
                    Mesh part = sleeve == ((PlayerModel)instance.m_7200_()).f_103374_ ? settings.getLeftArmMesh() : settings.getRightArmMesh();
                    part.copyFrom(arm);
                    poseStack.m_85836_();
                    poseStack.m_85841_(pixelScaling, armHeightScaling, pixelScaling);
                    boolean left = sleeve == ((PlayerModel)instance.m_7200_()).f_103374_;
                    float x = left ? 5.0f : -5.0f;
                    float y = 1.4f;
                    if (!thinArms) {
                        x = left ? (float)((double)x + 0.4) : (float)((double)x - 0.4);
                    }
                    part.setPosition(x, y, 0.0f);
                    part.render(poseStack, vertexConsumer, i, OverlayTexture.f_118083_);
                    part.setPosition(0.0f, 0.0f, 0.0f);
                    part.setRotation(0.0f, 0.0f, 0.0f);
                    poseStack.m_85849_();
                }
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Exception with ETF's 3D skin layers mod hand compatibility: " + e);
        }
        catch (NoClassDefFoundError error) {
            ETFUtils2.logError("Error with ETF's 3D skin layers mod hand compatibility: " + error);
        }
    }
}

