/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.utils.ETFUtils2;

public enum ETFDirectory {
    DOES_NOT_EXIST(null),
    ETF(new String[]{"textures", "etf/random"}),
    OLD_OPTIFINE(new String[]{"textures/entity", "optifine/mob"}),
    OPTIFINE(new String[]{"textures", "optifine/random"}),
    VANILLA(null);

    private static Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> ETF_DIRECTORY_CACHE;
    private final String[] replaceStrings;

    private ETFDirectory(String[] replaceStrings) {
        this.replaceStrings = replaceStrings;
    }

    public static void resetCache() {
        ETF_DIRECTORY_CACHE = new Object2ReferenceOpenHashMap();
    }

    public static Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> getCache() {
        if (ETF_DIRECTORY_CACHE == null) {
            ETF_DIRECTORY_CACHE = new Object2ReferenceOpenHashMap();
        }
        return ETF_DIRECTORY_CACHE;
    }

    @Nullable
    public static ResourceLocation getDirectoryVersionOf(ResourceLocation vanillaIdentifier) {
        ETFDirectory directory = ETFDirectory.getDirectoryOf(vanillaIdentifier);
        return switch (directory) {
            case DOES_NOT_EXIST -> null;
            case VANILLA -> vanillaIdentifier;
            default -> ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory);
        };
    }

    @NotNull
    public static ETFDirectory getDirectoryOf(ResourceLocation vanillaIdentifier) {
        Object2ReferenceOpenHashMap<@NotNull ResourceLocation, @NotNull ETFDirectory> cache = ETFDirectory.getCache();
        if (!cache.containsKey((Object)vanillaIdentifier)) {
            cache.put((Object)vanillaIdentifier, (Object)ETFDirectory.findDirectoryOf(vanillaIdentifier));
        }
        return (ETFDirectory)((Object)cache.get((Object)vanillaIdentifier));
    }

    @NotNull
    private static ETFDirectory findDirectoryOf(ResourceLocation vanillaIdentifier) {
        Optional resource;
        if (vanillaIdentifier.m_135815_().contains("etf/random/entity")) {
            resource = Minecraft.m_91087_().m_91098_().m_213713_(vanillaIdentifier);
            if (resource.isPresent()) {
                return ETF;
            }
        } else if (vanillaIdentifier.m_135815_().contains("optifine/random/entity")) {
            resource = Minecraft.m_91087_().m_91098_().m_213713_(vanillaIdentifier);
            if (resource.isPresent()) {
                return OPTIFINE;
            }
        } else if (vanillaIdentifier.m_135815_().contains("optifine/mob") && (resource = Minecraft.m_91087_().m_91098_().m_213713_(vanillaIdentifier)).isPresent()) {
            return OLD_OPTIFINE;
        }
        ObjectArrayList foundDirectories = new ObjectArrayList();
        ResourceManager resources = Minecraft.m_91087_().m_91098_();
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, VANILLA)).isPresent()) {
            foundDirectories.add((Object)VANILLA);
        }
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OLD_OPTIFINE)).isPresent()) {
            foundDirectories.add((Object)OLD_OPTIFINE);
        }
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, OPTIFINE)).isPresent()) {
            foundDirectories.add((Object)OPTIFINE);
        }
        if (resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, ETF)).isPresent()) {
            foundDirectories.add((Object)ETF);
        }
        if (foundDirectories.isEmpty()) {
            return DOES_NOT_EXIST;
        }
        if (foundDirectories.size() == 1) {
            return (ETFDirectory)((Object)foundDirectories.get(0));
        }
        Object2ReferenceOpenHashMap resourcePackNames = new Object2ReferenceOpenHashMap();
        for (ETFDirectory directory : foundDirectories) {
            Optional resource2 = resources.m_213713_(ETFDirectory.getIdentifierAsDirectory(vanillaIdentifier, directory));
            resource2.ifPresent(value -> resourcePackNames.put((Object)value.m_215506_(), (Object)directory));
        }
        String[] strArray = (String[])resourcePackNames.keySet().toArray((Object[])new String[0]);
        String returnedPack = ETFUtils2.returnNameOfHighestPackFromTheseMultiple(strArray);
        if (returnedPack != null) {
            return (ETFDirectory)((Object)resourcePackNames.get((Object)returnedPack));
        }
        return VANILLA;
    }

    @NotNull
    public static ResourceLocation getIdentifierAsDirectory(ResourceLocation identifier, ETFDirectory directory) {
        if (directory.doesReplace()) {
            return new ResourceLocation(identifier.m_135827_(), identifier.m_135815_().replace(directory.replaceStrings[0], directory.replaceStrings[1]));
        }
        return identifier;
    }

    public boolean doesReplace() {
        return this.replaceStrings != null;
    }

    static {
        ETF_DIRECTORY_CACHE = null;
    }
}

