/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.texture_handlers;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.entity_handlers.ETFEntity;
import traben.entity_texture_features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.texture_handlers.ETFSprite;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFTexture {
    private static final String PATCH_NAMESPACE_PREFIX = "etf_patched_";
    private static final Random randomBlink = new Random();
    public final ResourceLocation thisIdentifier;
    private final Object2ReferenceOpenHashMap<ResourceLocation, ResourceLocation> FEATURE_TEXTURE_MAP = new Object2ReferenceOpenHashMap();
    private final int variantNumber;
    public TextureReturnState currentTextureState = TextureReturnState.NORMAL;
    private ResourceLocation thisIdentifier_Patched = null;
    private ResourceLocation emissiveIdentifier = null;
    private ResourceLocation emissiveBlinkIdentifier = null;
    private ResourceLocation emissiveBlink2Identifier = null;
    private ResourceLocation blinkIdentifier = null;
    private ResourceLocation blink2Identifier = null;
    private ResourceLocation blinkIdentifier_Patched = null;
    private ResourceLocation blink2Identifier_Patched = null;
    private Integer blinkLength;
    private Integer blinkFrequency;
    private boolean canPatch;
    public String eSuffix;
    private ETFSprite atlasSprite;

    public int getVariantNumber() {
        return this.variantNumber;
    }

    public ETFTexture(ResourceLocation variantIdentifier, boolean allowedToPatch) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.eSuffix = null;
        this.atlasSprite = null;
        if (variantIdentifier == null) {
            ETFUtils2.logError("ETFTexture had a null identifier this MUST never happen");
            this.thisIdentifier = null;
            this.variantNumber = 0;
            return;
        }
        this.thisIdentifier = variantIdentifier;
        Pattern pattern = Pattern.compile("\\d+(?=\\.png)");
        Matcher matcher = pattern.matcher(variantIdentifier.m_135815_());
        int intFound = 0;
        try {
            if (matcher.find()) {
                intFound = Integer.parseInt(matcher.group());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.variantNumber = intFound;
        this.canPatch = allowedToPatch;
        this.setupBlinking();
        this.setupEmissives();
    }

    public ETFTexture(@NotNull ResourceLocation modifiedSkinIdentifier, @Nullable ResourceLocation blinkIdentifier, @Nullable ResourceLocation blink2Identifier, @Nullable ResourceLocation emissiveIdentifier, @Nullable ResourceLocation blinkEmissiveIdentifier, @Nullable ResourceLocation blink2EmissiveIdentifier, @Nullable ResourceLocation modifiedSkinPatchedIdentifier, @Nullable ResourceLocation modifiedSkinBlinkPatchedIdentifier, @Nullable ResourceLocation modifiedSkinBlink2PatchedIdentifier) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.eSuffix = null;
        this.atlasSprite = null;
        this.variantNumber = 0;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.blinkIdentifier = blinkIdentifier;
        this.blink2Identifier = blink2Identifier;
        this.emissiveIdentifier = emissiveIdentifier;
        this.emissiveBlinkIdentifier = blinkEmissiveIdentifier;
        this.emissiveBlink2Identifier = blink2EmissiveIdentifier;
        this.thisIdentifier_Patched = modifiedSkinPatchedIdentifier;
        this.blinkIdentifier_Patched = modifiedSkinBlinkPatchedIdentifier;
        this.blink2Identifier_Patched = modifiedSkinBlink2PatchedIdentifier;
    }

    public ETFTexture(@NotNull ResourceLocation modifiedSkinIdentifier, @Nullable ResourceLocation emissiveIdentifier) {
        this.blinkLength = ETFClientCommon.ETFConfigData.blinkLength;
        this.blinkFrequency = ETFClientCommon.ETFConfigData.blinkFrequency;
        this.canPatch = true;
        this.eSuffix = null;
        this.atlasSprite = null;
        this.variantNumber = 0;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.emissiveIdentifier = emissiveIdentifier;
    }

    public static void patchTextureToRemoveZFightingWithOtherTexture(NativeImage baseImage, NativeImage otherImage) throws IndexOutOfBoundsException {
        try {
            if (otherImage.m_84982_() == baseImage.m_84982_() && otherImage.m_85084_() == baseImage.m_85084_()) {
                for (int x = 0; x < baseImage.m_84982_(); ++x) {
                    for (int y = 0; y < baseImage.m_85084_(); ++y) {
                        if (otherImage.m_85087_(x, y) == 0) continue;
                        baseImage.m_84988_(x, y, 0);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IndexOutOfBoundsException("additional texture is not the correct size, ETF has crashed in the patching stage");
        }
    }

    private void setupBlinking() {
        String blink1PackName;
        ResourceLocation possibleBlinkIdentifier;
        Optional blinkR1;
        ResourceManager resourceManager;
        Optional vanillaR1;
        if (ETFClientCommon.ETFConfigData.enableBlinking && (vanillaR1 = (resourceManager = Minecraft.m_91087_().m_91098_()).m_213713_(this.thisIdentifier)).isPresent() && (blinkR1 = resourceManager.m_213713_(possibleBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink.png"))).isPresent() && (blink1PackName = ((Resource)blinkR1.get()).m_215506_()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{blink1PackName, ((Resource)vanillaR1.get()).m_215506_()}))) {
            String propertyResourcePackName;
            Optional propertyResource;
            ResourceLocation propertyIdentifier;
            Properties blinkingProps;
            String blink2PackName;
            this.blinkIdentifier = possibleBlinkIdentifier;
            ResourceLocation possibleBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2.png");
            Optional blinkR2 = resourceManager.m_213713_(possibleBlink2Identifier);
            if (blinkR2.isPresent() && blink1PackName.equals(blink2PackName = ((Resource)blinkR2.get()).m_215506_())) {
                this.blink2Identifier = possibleBlink2Identifier;
            }
            if ((blinkingProps = ETFUtils2.readAndReturnPropertiesElseNull(propertyIdentifier = ETFUtils2.replaceIdentifier(possibleBlinkIdentifier, ".png", ".properties"))) != null && (propertyResource = resourceManager.m_213713_(propertyIdentifier)).isPresent() && (propertyResourcePackName = ((Resource)propertyResource.get()).m_215506_()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{propertyResourcePackName, blink1PackName}))) {
                this.blinkLength = blinkingProps.containsKey("blinkLength") ? Integer.parseInt(blinkingProps.getProperty("blinkLength").replaceAll("\\D", "")) : ETFClientCommon.ETFConfigData.blinkLength;
                this.blinkFrequency = blinkingProps.containsKey("blinkFrequency") ? Integer.parseInt(blinkingProps.getProperty("blinkFrequency").replaceAll("\\D", "")) : ETFClientCommon.ETFConfigData.blinkFrequency;
            }
        }
    }

    private void setupEmissives() {
        if (ETFClientCommon.ETFConfigData.enableEmissiveTextures) {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            for (String possibleEmissiveSuffix : ETFManager.getInstance().EMISSIVE_SUFFIX_LIST) {
                String emissiveBlinkPackName;
                String emissivePackName;
                ResourceLocation possibleEmissiveIdentifier;
                Optional emissiveR1;
                Optional vanillaR1 = resourceManager.m_213713_(this.thisIdentifier);
                if (vanillaR1.isEmpty() && this.thisIdentifier.m_135815_().contains("textures/trims/models/armor/")) {
                    vanillaR1 = resourceManager.m_213713_(new ResourceLocation(this.thisIdentifier.m_135827_(), this.thisIdentifier.m_135815_().replaceAll("_(.*?)(?=\\.png)", "")));
                    String pack = vanillaR1.isPresent() ? ((Resource)vanillaR1.get()).m_215506_() : "minecraft";
                    vanillaR1 = Optional.of(new Resource(pack, null));
                }
                if (!vanillaR1.isPresent() || !(emissiveR1 = resourceManager.m_213713_(possibleEmissiveIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", possibleEmissiveSuffix + ".png"))).isPresent() || !(emissivePackName = ((Resource)emissiveR1.get()).m_215506_()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissivePackName, vanillaR1.get().m_215506_()}))) continue;
                this.emissiveIdentifier = possibleEmissiveIdentifier;
                ResourceLocation possibleEmissiveBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink" + possibleEmissiveSuffix + ".png");
                Optional emissiveBlinkR1 = resourceManager.m_213713_(possibleEmissiveBlinkIdentifier);
                if (emissiveBlinkR1.isPresent() && (emissiveBlinkPackName = ((Resource)emissiveBlinkR1.get()).m_215506_()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissiveBlinkPackName, vanillaR1.get().m_215506_()}))) {
                    String emissiveBlink2PackName;
                    this.emissiveBlinkIdentifier = possibleEmissiveBlinkIdentifier;
                    ResourceLocation possibleEmissiveBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2" + possibleEmissiveSuffix + ".png");
                    Optional emissiveBlink2R1 = resourceManager.m_213713_(possibleEmissiveBlink2Identifier);
                    if (emissiveBlink2R1.isPresent() && (emissiveBlink2PackName = ((Resource)emissiveBlink2R1.get()).m_215506_()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(new String[]{emissiveBlink2PackName, vanillaR1.get().m_215506_()}))) {
                        this.emissiveBlink2Identifier = possibleEmissiveBlink2Identifier;
                    }
                }
                this.eSuffix = possibleEmissiveSuffix;
                break;
            }
            if (this.isEmissive()) {
                this.createPatchedTextures();
            }
        }
    }

    private void createPatchedTextures() {
        if (this.canPatch) {
            return;
        }
        NativeImage newBaseTexture = ETFUtils2.getNativeImageElseNull(this.thisIdentifier);
        NativeImage newBlinkTexture = ETFUtils2.getNativeImageElseNull(this.blinkIdentifier);
        NativeImage newBlink2Texture = ETFUtils2.getNativeImageElseNull(this.blink2Identifier);
        boolean didPatch = false;
        ResourceManager files = Minecraft.m_91087_().m_91098_();
        if (ETFClientCommon.ETFConfigData.dontPatchPBRTextures && (ETFVersionDifferenceHandler.isThisModLoaded("iris") || ETFVersionDifferenceHandler.isThisModLoaded("oculus")) && (files.m_213713_(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_s.png")).isPresent() || files.m_213713_(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_n.png")).isPresent())) {
            return;
        }
        if (ETFClientCommon.ETFConfigData.dontPatchAnimatedTextures && (ETFVersionDifferenceHandler.isThisModLoaded("animatica") && (ETFTexture.doesAnimaticaVersionExist(this.thisIdentifier) || ETFTexture.doesAnimaticaVersionExist(this.emissiveIdentifier)) || ETFVersionDifferenceHandler.isThisModLoaded("moremcmeta") && (files.m_213713_(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.mcmeta")).isPresent() || files.m_213713_(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.moremcmeta")).isPresent()))) {
            return;
        }
        if (this.emissiveIdentifier != null && ETFClientCommon.ETFConfigData.enableEmissiveTextures) {
            NativeImage emissiveImage = ETFUtils2.getNativeImageElseNull(this.emissiveIdentifier);
            try {
                ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBaseTexture, emissiveImage);
                didPatch = true;
                if (this.doesBlink() && this.emissiveBlinkIdentifier != null) {
                    NativeImage emissiveBlinkImage = ETFUtils2.getNativeImageElseNull(this.emissiveBlinkIdentifier);
                    ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlinkTexture, emissiveBlinkImage);
                    if (this.doesBlink2() && this.emissiveBlink2Identifier != null) {
                        NativeImage emissiveBlink2Image = ETFUtils2.getNativeImageElseNull(this.emissiveBlink2Identifier);
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlink2Texture, emissiveBlink2Image);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (didPatch) {
                this.thisIdentifier_Patched = new ResourceLocation(PATCH_NAMESPACE_PREFIX + this.thisIdentifier.m_135827_(), this.thisIdentifier.m_135815_());
                ETFUtils2.registerNativeImageToIdentifier(newBaseTexture, this.thisIdentifier_Patched);
                if (this.doesBlink()) {
                    this.blinkIdentifier_Patched = new ResourceLocation(PATCH_NAMESPACE_PREFIX + this.blinkIdentifier.m_135827_(), this.blinkIdentifier.m_135815_());
                    ETFUtils2.registerNativeImageToIdentifier(newBlinkTexture, this.blinkIdentifier_Patched);
                    if (this.doesBlink2()) {
                        this.blink2Identifier_Patched = new ResourceLocation(PATCH_NAMESPACE_PREFIX + this.blink2Identifier.m_135827_(), this.blink2Identifier.m_135815_());
                        ETFUtils2.registerNativeImageToIdentifier(newBlink2Texture, this.blink2Identifier_Patched);
                    }
                }
            }
        }
    }

    private static boolean doesAnimaticaVersionExist(ResourceLocation identifier) {
        if (identifier == null) {
            return false;
        }
        String idString = identifier.toString();
        if (idString.endsWith("-anim")) {
            return true;
        }
        return Minecraft.m_91087_().m_91097_().m_174786_(new ResourceLocation(idString + "-anim"), null) != null;
    }

    @NotNull
    ResourceLocation getFeatureTexture(ResourceLocation vanillaFeatureTexture) {
        ETFDirectory tryDirectory;
        if (this.FEATURE_TEXTURE_MAP.containsKey((Object)vanillaFeatureTexture)) {
            return (ResourceLocation)this.FEATURE_TEXTURE_MAP.get((Object)vanillaFeatureTexture);
        }
        ETFDirectory directory = ETFDirectory.getDirectoryOf(this.thisIdentifier);
        if (this.variantNumber != 0) {
            ResourceLocation possibleFeatureVariantIdentifier = ETFDirectory.getIdentifierAsDirectory(ETFUtils2.replaceIdentifier(vanillaFeatureTexture, ".png", this.variantNumber + ".png"), directory);
            Optional possibleResource = Minecraft.m_91087_().m_91098_().m_213713_(possibleFeatureVariantIdentifier);
            if (possibleResource.isPresent()) {
                this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)possibleFeatureVariantIdentifier);
                return possibleFeatureVariantIdentifier;
            }
        }
        if ((tryDirectory = ETFDirectory.getDirectoryOf(vanillaFeatureTexture)) == directory || tryDirectory == ETFDirectory.VANILLA) {
            ResourceLocation tryDirectoryVariant = ETFDirectory.getIdentifierAsDirectory(vanillaFeatureTexture, tryDirectory);
            this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)tryDirectoryVariant);
            return tryDirectoryVariant;
        }
        this.FEATURE_TEXTURE_MAP.put((Object)vanillaFeatureTexture, (Object)vanillaFeatureTexture);
        return vanillaFeatureTexture;
    }

    @NotNull
    public ResourceLocation getTextureIdentifier(ETFEntity entity) {
        return this.getTextureIdentifier(entity, false);
    }

    @NotNull
    public ResourceLocation getTextureIdentifier(@Nullable ETFEntity entity, boolean forcePatchedTexture) {
        if (this.isPatched() && (forcePatchedTexture || ETFClientCommon.ETFConfigData.enableEmissiveTextures && ETFVersionDifferenceHandler.areShadersInUse() || Minecraft.m_91087_().f_91080_ instanceof ETFConfigScreen)) {
            this.currentTextureState = TextureReturnState.NORMAL_PATCHED;
            return this.getBlinkingIdentifier(entity);
        }
        this.currentTextureState = TextureReturnState.NORMAL;
        return this.getBlinkingIdentifier(entity);
    }

    @NotNull
    private ResourceLocation getBlinkingIdentifier(@Nullable ETFEntity entity) {
        LivingEntity alive;
        if (!this.doesBlink() || entity == null || !ETFClientCommon.ETFConfigData.enableBlinking) {
            return this.identifierOfCurrentState();
        }
        if (entity.getPose() == Pose.SLEEPING) {
            this.modifyTextureState(TextureReturnState.APPLY_BLINK);
            return this.identifierOfCurrentState();
        }
        Entity entity2 = entity.entity();
        if (entity2 instanceof LivingEntity && (alive = (LivingEntity)entity2).m_21023_(MobEffects.f_19610_)) {
            this.modifyTextureState(this.doesBlink2() ? TextureReturnState.APPLY_BLINK2 : TextureReturnState.APPLY_BLINK);
            return this.identifierOfCurrentState();
        }
        if (entity.getWorld() != null) {
            UUID id = entity.getUuid();
            if (!ETFManager.getInstance().ENTITY_BLINK_TIME.containsKey((Object)id)) {
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)id, entity.getWorld().m_46467_() + (long)this.blinkLength.intValue() + 1L);
                return this.identifierOfCurrentState();
            }
            long nextBlink = ETFManager.getInstance().ENTITY_BLINK_TIME.getLong((Object)id);
            long currentTime = entity.getWorld().m_46467_();
            if (currentTime >= nextBlink - (long)this.blinkLength.intValue() && currentTime <= nextBlink + (long)this.blinkLength.intValue()) {
                if (this.doesBlink2()) {
                    if (currentTime >= nextBlink - (long)(this.blinkLength / 3) && currentTime <= nextBlink + (long)(this.blinkLength / 3)) {
                        this.modifyTextureState(TextureReturnState.APPLY_BLINK);
                        return this.identifierOfCurrentState();
                    }
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK2);
                    return this.identifierOfCurrentState();
                }
                if (currentTime <= nextBlink) {
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK);
                    return this.identifierOfCurrentState();
                }
            } else if (currentTime > nextBlink + (long)this.blinkLength.intValue()) {
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)id, currentTime + (long)randomBlink.nextInt(this.blinkFrequency) + 20L);
            }
        }
        return this.identifierOfCurrentState();
    }

    public boolean isEmissive() {
        return this.emissiveIdentifier != null;
    }

    public boolean isPatched() {
        return this.thisIdentifier_Patched != null;
    }

    public boolean doesBlink() {
        return this.blinkIdentifier != null;
    }

    @NotNull
    public ETFSprite getSprite(@NotNull TextureAtlasSprite originalSprite) {
        if (this.atlasSprite == null) {
            this.atlasSprite = new ETFSprite(originalSprite, this);
        }
        return this.atlasSprite;
    }

    public boolean doesBlink2() {
        return this.blink2Identifier != null;
    }

    public String toString() {
        return "ETFTexture{texture=" + this.thisIdentifier.toString() + ", emissive=" + this.isEmissive() + ", patched=" + this.isPatched() + "}";
    }

    public void renderEmissive(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, ModelPart modelPart) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, modelPart, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, ModelPart modelPart, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        VertexConsumer vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, null, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            modelPart.m_104301_(matrixStack, vertexC, 0xF000F2, OverlayTexture.f_118083_);
        }
    }

    public void renderEmissive(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Model model) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, model, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Model model, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        VertexConsumer vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, model, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            model.m_7695_(matrixStack, vertexC, 0xF000F2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Nullable
    public VertexConsumer getEmissiveVertexConsumer(MultiBufferSource vertexConsumerProvider, @Nullable Model model, ETFManager.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        ResourceLocation emissiveToUse;
        if (this.isEmissive() && (emissiveToUse = this.getEmissiveIdentifierOfCurrentState()) != null) {
            if (modeToUsePossiblyManuallyChosen == ETFManager.EmissiveRenderModes.BRIGHT) {
                return vertexConsumerProvider.m_6299_(RenderType.m_110460_((ResourceLocation)emissiveToUse, (!ETFVersionDifferenceHandler.areShadersInUse() ? 1 : 0) != 0));
            }
            if (model == null) {
                return vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)emissiveToUse));
            }
            return vertexConsumerProvider.m_6299_(model.m_103119_(emissiveToUse));
        }
        return null;
    }

    private void modifyTextureState(TextureReturnState givenState) {
        switch (givenState) {
            case APPLY_BLINK: {
                this.currentTextureState = this.currentTextureState == TextureReturnState.NORMAL_PATCHED ? TextureReturnState.BLINK_PATCHED : TextureReturnState.BLINK;
                break;
            }
            case APPLY_BLINK2: {
                this.currentTextureState = switch (this.currentTextureState) {
                    case TextureReturnState.NORMAL_PATCHED, TextureReturnState.BLINK_PATCHED -> TextureReturnState.BLINK2_PATCHED;
                    default -> TextureReturnState.BLINK2;
                };
            }
        }
    }

    @NotNull
    private ResourceLocation identifierOfCurrentState() {
        return switch (this.currentTextureState) {
            case TextureReturnState.NORMAL -> this.thisIdentifier;
            case TextureReturnState.NORMAL_PATCHED -> this.thisIdentifier_Patched;
            case TextureReturnState.BLINK -> this.blinkIdentifier;
            case TextureReturnState.BLINK_PATCHED -> this.blinkIdentifier_Patched;
            case TextureReturnState.BLINK2 -> this.blink2Identifier;
            case TextureReturnState.BLINK2_PATCHED -> this.blink2Identifier_Patched;
            default -> this.thisIdentifier;
        };
    }

    @Nullable
    public ResourceLocation getEmissiveIdentifierOfCurrentState() {
        return switch (this.currentTextureState) {
            case TextureReturnState.NORMAL_PATCHED, TextureReturnState.NORMAL -> this.emissiveIdentifier;
            case TextureReturnState.BLINK_PATCHED, TextureReturnState.BLINK -> this.emissiveBlinkIdentifier;
            case TextureReturnState.BLINK2, TextureReturnState.BLINK2_PATCHED -> this.emissiveBlink2Identifier;
            default -> null;
        };
    }

    public static enum TextureReturnState {
        NORMAL,
        NORMAL_PATCHED,
        BLINK,
        BLINK_PATCHED,
        BLINK2,
        BLINK2_PATCHED,
        APPLY_PATCH,
        APPLY_BLINK,
        APPLY_BLINK2;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> "normal";
                case BLINK -> "blink";
                case BLINK2 -> "blink2";
                case NORMAL_PATCHED -> "normal_patched";
                case BLINK_PATCHED -> "blink_patched";
                case BLINK2_PATCHED -> "blink2_patched";
                case APPLY_BLINK -> "apply_blink";
                case APPLY_BLINK2 -> "apply_blink2";
                case APPLY_PATCH -> "apply_patch";
            };
        }
    }
}

