/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreenWarnings;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFLruCache;

public abstract class ETFUtils2 {
    public static ETFLruCache<ResourceLocation, NativeImage> KNOWN_NATIVE_IMAGES = new ETFLruCache();

    @NotNull
    public static ResourceLocation addVariantNumberSuffix(ResourceLocation identifier, int variant) {
        return new ResourceLocation(ETFUtils2.addVariantNumberSuffix(identifier.toString(), variant));
    }

    @NotNull
    public static String addVariantNumberSuffix(String identifierString, int variant) {
        if (identifierString.matches("\\d\\.png")) {
            return identifierString.replace(".png", "." + variant + ".png");
        }
        return identifierString.replace(".png", variant + ".png");
    }

    @Nullable
    public static ResourceLocation replaceIdentifier(ResourceLocation id, String regex, String replace) {
        ResourceLocation forReturn;
        if (id == null) {
            return null;
        }
        try {
            forReturn = new ResourceLocation(id.m_135827_(), id.m_135815_().replaceFirst(regex, replace));
        }
        catch (ResourceLocationException idFail) {
            ETFUtils2.logError(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.illegal_path_recommendation").getString() + "\n" + idFail);
            forReturn = null;
        }
        catch (Exception e) {
            forReturn = null;
        }
        return forReturn;
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseMultiple(String[] packNameList) {
        ArrayList<String> packNames = new ArrayList<String>(Arrays.asList(packNameList));
        while (packNames.size() >= 2) {
            if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(0)) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNames.get(1))) {
                packNames.remove(1);
                continue;
            }
            packNames.remove(0);
        }
        return packNames.get(0);
    }

    public static boolean isNativeImageEmpty(@NotNull NativeImage image) {
        boolean foundNonEmptyPixel = false;
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                if (image.m_84985_(x, y) == 0) continue;
                foundNonEmptyPixel = true;
                break;
            }
            if (foundNonEmptyPixel) break;
        }
        return !foundNonEmptyPixel;
    }

    @Nullable
    public static String returnNameOfHighestPackFromTheseTwo(String[] packNameList) {
        if (packNameList.length != 2) {
            ETFUtils2.logError("highest pack check failed");
            return null;
        }
        if (packNameList[0].equals(packNameList[1])) {
            return packNameList[0];
        }
        if (ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNameList[0]) >= ETFManager.getInstance().KNOWN_RESOURCEPACK_ORDER.indexOf(packNameList[1])) {
            return packNameList[0];
        }
        return packNameList[1];
    }

    @Nullable
    public static Properties readAndReturnPropertiesElseNull(ResourceLocation path) {
        Properties props = new Properties();
        try {
            Resource resource = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(path).get();
            try {
                InputStream in = resource.m_215507_();
                props.load(in);
                in.close();
                return props;
            }
            catch (Exception e) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static NativeImage getNativeImageElseNull(@Nullable ResourceLocation identifier) {
        if (identifier != null && KNOWN_NATIVE_IMAGES.get(identifier) != null) {
            return KNOWN_NATIVE_IMAGES.get(identifier);
        }
        try {
            InputStream in = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(identifier).get()).m_215507_();
            try {
                NativeImage img = NativeImage.m_85058_((InputStream)in);
                in.close();
                KNOWN_NATIVE_IMAGES.put(identifier, img);
                return img;
            }
            catch (Exception e) {
                in.close();
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void logMessage(String obj) {
        ETFUtils2.logMessage(obj, false);
    }

    public static void logMessage(String obj, boolean inChat) {
        if (inChat) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("[INFO] [Entity Texture Features]: " + obj)).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}), false);
            } else {
                ETFClientCommon.LOGGER.info(obj);
            }
        } else {
            ETFClientCommon.LOGGER.info(obj);
        }
    }

    public static void logWarn(String obj) {
        ETFUtils2.logWarn(obj, false);
    }

    public static void logWarn(String obj, boolean inChat) {
        if (inChat) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("[WARN] [Entity Texture Features]: " + obj)).m_130940_(ChatFormatting.YELLOW), false);
            } else {
                ETFClientCommon.LOGGER.warn(obj);
            }
        } else {
            ETFClientCommon.LOGGER.warn(obj);
        }
    }

    public static void logError(String obj) {
        ETFUtils2.logError(obj, false);
    }

    public static void logError(String obj, boolean inChat) {
        if (inChat) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("[ERROR] [Entity Texture Features]: " + obj)).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), false);
            } else {
                ETFClientCommon.LOGGER.error(obj);
            }
        } else {
            ETFClientCommon.LOGGER.error(obj);
        }
    }

    public static void saveConfig() {
        File config = new File(ETFClientCommon.CONFIG_DIR, "entity_texture_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)ETFClientCommon.ETFConfigData));
            fileWriter.close();
        }
        catch (IOException e) {
            ETFUtils2.logError("Config file could not be saved", false);
        }
    }

    public static NativeImage emptyNativeImage() {
        return ETFUtils2.emptyNativeImage(64, 64);
    }

    public static NativeImage emptyNativeImage(int Width, int Height) {
        NativeImage empty = new NativeImage(Width, Height, false);
        empty.m_84997_(0, 0, Width, Height, 0);
        return empty;
    }

    public static boolean registerNativeImageToIdentifier(NativeImage img, ResourceLocation identifier) {
        if (img != null && identifier != null) {
            DynamicTexture bob = new DynamicTexture(img);
            Minecraft.m_91087_().m_91097_().m_118495_(identifier, (AbstractTexture)bob);
            KNOWN_NATIVE_IMAGES.put(identifier, img);
            return true;
        }
        ETFUtils2.logError("registering native image failed: " + img + ", " + identifier);
        return false;
    }

    public static void checkModCompatibility() {
        if (ETFVersionDifferenceHandler.isThisModLoaded("figura") && !ETFClientCommon.ETFConfigData.ignoredConfigs.contains((Object)ETFConfigScreenWarnings.ConfigWarning.FIGURA)) {
            ETFClientCommon.ETFConfigData.skinFeaturesEnabled = false;
            ETFUtils2.saveConfig();
        }
    }
}

