/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.allurement.core.AllurementConfig;
import com.teamabnormals.allurement.core.registry.AllurementEnchantments;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AscensionCurseLootModifier
extends LootModifier {
    public static final Supplier<Codec<AscensionCurseLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AscensionCurseLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AscensionCurseLootModifier::new)));

    public AscensionCurseLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)AllurementConfig.COMMON.enableAscensionCurse.get()).booleanValue() && !BuiltInLootTables.f_78741_.equals((Object)context.getQueriedLootTableId())) {
            for (ItemStack stack : generatedLoot) {
                if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)AllurementEnchantments.ASCENSION_CURSE.get()), (ItemStack)stack) <= 0) continue;
                Map enchantments = stack.getAllEnchantments();
                enchantments.remove(AllurementEnchantments.ASCENSION_CURSE.get());
                EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

