/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.core;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="allurement")
public class AllurementConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        @ConfigKey(value="enchantable_horse_armor")
        public final ForgeConfigSpec.BooleanValue enchantableHorseArmor;
        public final ForgeConfigSpec.BooleanValue enchantedHorseArmorGenerates;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> unenchantedHorseArmorLootTables;
        public final ForgeConfigSpec.BooleanValue baneOfArthropodsBreaksCobwebsFaster;
        public final ForgeConfigSpec.BooleanValue featherFallingPreventsTrampling;
        public final ForgeConfigSpec.BooleanValue infinityRequiresArrows;
        public final ForgeConfigSpec.BooleanValue disableProtection;
        public final ForgeConfigSpec.BooleanValue riptideWorksInCauldrons;
        public final ForgeConfigSpec.BooleanValue soulSpeedHurtsMore;
        public final ForgeConfigSpec.DoubleValue soulSpeedDamageFactor;
        public final ForgeConfigSpec.BooleanValue enableAlleviating;
        public final ForgeConfigSpec.DoubleValue alleviatingHealingFactor;
        public final ForgeConfigSpec.BooleanValue enableLaunch;
        public final ForgeConfigSpec.DoubleValue launchVerticalFactor;
        @ConfigKey(value="enable_obedience")
        public final ForgeConfigSpec.BooleanValue enableObedience;
        public final ForgeConfigSpec.BooleanValue enableReeling;
        public final ForgeConfigSpec.DoubleValue reelingHorizontalFactor;
        public final ForgeConfigSpec.DoubleValue reelingVerticalFactor;
        public final ForgeConfigSpec.BooleanValue enableReforming;
        public final ForgeConfigSpec.IntValue reformingTickRate;
        public final ForgeConfigSpec.BooleanValue enableShockwave;
        public final ForgeConfigSpec.BooleanValue shockwaveTramplesFarmland;
        public final ForgeConfigSpec.BooleanValue enableVengeance;
        public final ForgeConfigSpec.DoubleValue vengeanceDamageFactor;
        public final ForgeConfigSpec.BooleanValue enableSpreadOfAilments;
        public final ForgeConfigSpec.BooleanValue enableAscensionCurse;
        public final ForgeConfigSpec.BooleanValue enableFleetingCurse;
        public final ForgeConfigSpec.BooleanValue dropExperiencePercentage;
        public final ForgeConfigSpec.DoubleValue experiencePercentage;
        public final ForgeConfigSpec.BooleanValue removeLevelScaling;
        public final ForgeConfigSpec.BooleanValue removeLevelScalingAfterCap;
        public final ForgeConfigSpec.IntValue experiencePerLevel;
        public final ForgeConfigSpec.BooleanValue adjustEnderDragonExperienceDrop;
        public final ForgeConfigSpec.IntValue enderDragonExperienceDrop;
        public final ForgeConfigSpec.IntValue respawnedEnderDragonExperienceDrop;
        public final ForgeConfigSpec.BooleanValue cheapItemRenaming;
        public final ForgeConfigSpec.BooleanValue removeTooExpensive;
        public final ForgeConfigSpec.BooleanValue capAnvilCosts;
        public final ForgeConfigSpec.IntValue anvilCostCap;
        public final ForgeConfigSpec.BooleanValue anvilIngotRepairing;
        public final ForgeConfigSpec.IntValue ingotRepairChance;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("enchantments");
            builder.push("alleviating");
            this.enableAlleviating = builder.comment("Armor enchantment that heals the user when collecting experience").define("Enable Alleviating", true);
            this.alleviatingHealingFactor = builder.comment("How much the experience value is multiplied by into health").defineInRange("Healing factor", 0.25, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("launch");
            this.enableLaunch = builder.comment("Weapon enchantment that launches enemies upwards rather than away").define("Enable Launch", true);
            this.launchVerticalFactor = builder.comment("How much the target is affected on the vertical axis").defineInRange("Vertical factor", 0.35, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("obedience");
            this.enableObedience = builder.comment("Horse armor enchantment tha prevents the horse from roaming around").define("Enable Obedience", true);
            builder.pop();
            builder.push("reeling");
            this.enableReeling = builder.comment("Crossbow enchantment that pulls targets towards the user").define("Enable Reeling", true);
            this.reelingHorizontalFactor = builder.comment("How much the target is affected on the horizontal axis").defineInRange("Horizontal factor", 0.5, 0.0, Double.MAX_VALUE);
            this.reelingVerticalFactor = builder.comment("How much the target is affected on the vertical axis").defineInRange("Vertical factor", 0.25, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("reforming");
            this.enableReforming = builder.comment("Gear enchantment that very slowly repairs items over time").define("Enable Reforming", true);
            this.reformingTickRate = builder.comment("How many ticks it takes a reforming item to repair").defineInRange("Reforming tick rate", 600, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("shockwave");
            this.enableShockwave = builder.comment("Boots enchantment that creates a shockwave when taking fall damage").define("Enable Shockwave", true);
            this.shockwaveTramplesFarmland = builder.comment("If Shockwave tramples farmland within the wave radius").define("Shockwave tramples farmland", true);
            builder.pop();
            builder.push("vengeance");
            this.enableVengeance = builder.comment("Armor enchantment that stores incoming damage and applies it to user's next attack").define("Enable Vengeance", true);
            this.vengeanceDamageFactor = builder.comment("How much the damage taken with vengeance is multiplied for attacks").defineInRange("Damage factor", 0.025, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("spread_of_ailments");
            this.enableSpreadOfAilments = builder.comment("Crossbow enchantment that applies the user's active effects to their arrows").define("Enable Spread of Ailments", true);
            builder.pop();
            builder.pop();
            builder.push("curses");
            builder.push("ascension_curse");
            this.enableAscensionCurse = builder.comment("Curse that causes the cursed item to float upwards when dropped").define("Enable Curse of Ascension", true);
            builder.pop();
            builder.push("fleeting_curse");
            this.enableFleetingCurse = builder.comment("Curse that causes nearby entities to repel the cursed item").define("Enable Curse of Fleeting", true);
            builder.pop();
            builder.pop();
            builder.push("tweaks");
            builder.push("horse_armor");
            this.enchantableHorseArmor = builder.comment("Allow horse armor to be enchanted").define("Enchantable horse armor", true);
            this.enchantedHorseArmorGenerates = builder.comment("If horse armor can appear enchanted when found in loot tables").define("Generates in loot tables", true);
            this.unenchantedHorseArmorLootTables = builder.comment("Which loot tables horse armor can't appear enchanted in").define("Unenchanted loot tables", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:chests/village/village_weaponsmith", "minecraft:chests/stronghold_corridor", "minecraft:chests/nether_bridge"}));
            builder.pop();
            builder.push("bane_of_arthropods");
            this.baneOfArthropodsBreaksCobwebsFaster = builder.comment("If Bane of Arthropods increases the mining speed of Cobwebs").define("Bane of Arthropods mines cobwebs faster", true);
            builder.pop();
            builder.push("feather_falling");
            this.featherFallingPreventsTrampling = builder.comment("If having Feather Falling prevents farmland from being trampled").define("Feather Falling prevents trampling", true);
            builder.pop();
            builder.push("infinity");
            this.infinityRequiresArrows = builder.comment("If Infinity requires an arrow in the player's inventory in order to shoot").define("Infinity requires arrows", false);
            builder.pop();
            builder.push("protection");
            this.disableProtection = builder.comment("Remove the base Protection enchantment, requiring players to choose between the other types").define("Disable Protection", false);
            builder.pop();
            builder.push("riptide");
            this.riptideWorksInCauldrons = builder.comment("Allow Riptide to function when in cauldrons").define("Riptide works in cauldrons", true);
            builder.pop();
            builder.push("soul_speed");
            this.soulSpeedHurtsMore = builder.comment("Instead of losing durability as you run, Soul Speed makes incoming damage increase when on Soul Speed blocks").define("Soul Speed change", true);
            this.soulSpeedDamageFactor = builder.comment("How much damage is multiplied when hurt on Soul Speed blocks").defineInRange("Damage factor", 1.5, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.push("experience");
            builder.push("dropped_xp");
            this.dropExperiencePercentage = builder.comment("If the player drops a flat percentage of their experience rather than capping at level 7").define("Drop experience percentage", false);
            this.experiencePercentage = builder.comment("What percentage of the player's total experience is dropped").defineInRange("Experience percentage", 0.75, 0.0, 1.0);
            builder.pop();
            builder.push("level_scaling");
            this.removeLevelScaling = builder.comment("Remove the amount of experience per level increasing (experimental)").define("Remove level scaling", false);
            this.experiencePerLevel = builder.comment("The amount of experience per level, if level scaling is removed (experimental)").defineInRange("Experience per level", 50, 0, Integer.MAX_VALUE);
            this.removeLevelScalingAfterCap = builder.comment("If the level scaling should only be modified after it reaches the 'Experience per level' value (experimental)").define("Remove level scaling after cap", true);
            builder.pop();
            builder.push("ender_dragon");
            this.adjustEnderDragonExperienceDrop = builder.comment("If Ender Dragon experience dropping should be adjusted (to account for level scaling)").define("Adjust Ender Dragon experience drop", false);
            this.enderDragonExperienceDrop = builder.comment("The amount of experience (in points) that should be dropped by the Ender Dragon").defineInRange("Ender Dragon experience drop", 3000, 0, Integer.MAX_VALUE);
            this.respawnedEnderDragonExperienceDrop = builder.comment("The amount of experience (in points) that should be dropped by a respawned Ender Dragon").defineInRange("Respawned Ender Dragon experience drop", 750, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("anvil");
            this.cheapItemRenaming = builder.comment("If renaming items should always cost 1 experience").define("Cheap item renaming", true);
            this.removeTooExpensive = builder.comment("Remove the cap of 40 on anvil repairing prices").define("Remove too expensive", true);
            this.anvilIngotRepairing = builder.comment("If anvils can be repaired by right clicking with an iron ingot or using a dispenser").define("Anvil ingot repairing", true);
            this.ingotRepairChance = builder.comment("The amount of tries it should take on average to repair an anvil with an ingot (1 in x chance)").defineInRange("Ingot repair chance", 5, 0, Integer.MAX_VALUE);
            this.capAnvilCosts = builder.comment("If anvil transaction costs should be capped at a certain level").define("Cap anvil costs", false);
            this.anvilCostCap = builder.comment("The max amount of levels an anvil transaction should be able to cost").defineInRange("Anvil cost cap", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue infinityArrowTexture;
        public final ForgeConfigSpec.BooleanValue infinityArrowGlint;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("tweaks");
            builder.push("infinity");
            this.infinityArrowTexture = builder.comment("Adds a special texture for arrows shot from infinity bows").define("Infinity arrow texture", true);
            this.infinityArrowGlint = builder.comment("Adds a glint on arrows shot from infinity bows").define("Infinity arrow glint", true);
            builder.pop();
            builder.pop();
        }
    }
}

