/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.allurement.core.other;

import com.google.common.collect.Maps;
import com.teamabnormals.allurement.core.AllurementConfig;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import vazkii.quark.content.tools.module.ColorRunesModule;

@Mod.EventBusSubscriber(modid="allurement")
public class AllurementUtil {
    public static final Map<String, Integer> ENCHANTABILITY_MAP = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put("minecraft:leather_horse_armor", 15);
        map.put("minecraft:iron_horse_armor", 9);
        map.put("minecraft:golden_horse_armor", 25);
        map.put("minecraft:diamond_horse_armor", 10);
        map.put("caverns_and_chasms:netherite_horse_armor", 15);
        map.put("caverns_and_chasms:silver_horse_armor", 17);
        map.put("caverns_and_chasms:necromium_horse_armor", 13);
    });

    public static int getTotalEnchantmentLevel(Enchantment ench, LivingEntity entity, EquipmentSlot.Type group) {
        int count = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != group) continue;
            count += entity.m_6844_(slot).getEnchantmentLevel(ench);
        }
        return count;
    }

    public static int getXpNeededForNextLevel(int experienceLevel) {
        int original;
        int n = experienceLevel >= 30 ? 112 + (experienceLevel - 30) * 9 : (original = experienceLevel >= 15 ? 37 + (experienceLevel - 15) * 5 : 7 + experienceLevel * 2);
        if (((Boolean)AllurementConfig.COMMON.removeLevelScaling.get()).booleanValue()) {
            int xpPerLevel = (Integer)AllurementConfig.COMMON.experiencePerLevel.get();
            if (((Boolean)AllurementConfig.COMMON.removeLevelScalingAfterCap.get()).booleanValue()) {
                return Math.min(original, xpPerLevel);
            }
            return xpPerLevel;
        }
        return original;
    }

    public static void ascendItem(ItemEntity entity) {
        Vec3 motion = entity.m_20184_();
        entity.m_20334_(motion.f_82479_, (0.25 - motion.f_82480_) * 0.3, motion.f_82481_);
    }

    public static void repelItem(ItemEntity entity) {
        Level level = entity.m_9236_();
        Vec3 motion = entity.m_20184_();
        double distance = -1.0;
        LivingEntity followingPlayer = null;
        for (LivingEntity living : level.m_6443_(LivingEntity.class, entity.m_20191_().m_82400_(5.0), livingEntity -> true)) {
            double newDistance = living.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (distance != -1.0 && !(newDistance < distance)) continue;
            distance = newDistance;
            followingPlayer = living;
        }
        if (followingPlayer != null) {
            Vec3 vec3 = new Vec3(entity.m_20185_() - followingPlayer.m_20185_(), entity.m_20186_() - (followingPlayer.m_20186_() + (double)followingPlayer.m_20192_() / 2.0), entity.m_20189_() - followingPlayer.m_20189_());
            Vec3 amount = vec3.m_82541_().m_82542_(0.1, 0.0, 0.1);
            amount = !entity.m_20096_() ? amount.m_82542_(0.2, 0.0, 0.2) : amount.m_82520_(0.0, 0.25, 0.0);
            entity.m_20256_(motion.m_82549_(amount));
        }
    }

    public static void setColorRuneTarget(ItemStack stack) {
        if (ModList.get().isLoaded("quark")) {
            ColorRunesModule.setTargetStack((ItemStack)stack);
        }
    }
}

