/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCoreConfig;
import team.creative.creativecore.CreativeForgeLoader;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.config.event.ConfigEventHandler;
import team.creative.creativecore.common.config.gui.ClientSyncGuiLayer;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorButton;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigurationChangePacket;
import team.creative.creativecore.common.config.sync.ConfigurationClientPacket;
import team.creative.creativecore.common.config.sync.ConfigurationPacket;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.gui.creator.GuiLayerCreator;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.GuiEventHandler;
import team.creative.creativecore.common.gui.packet.ControlSyncPacket;
import team.creative.creativecore.common.gui.packet.LayerClosePacket;
import team.creative.creativecore.common.gui.packet.LayerOpenPacket;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.loader.ForgeLoaderUtils;
import team.creative.creativecore.common.loader.ILoaderUtils;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.util.argument.StringArrayArgumentType;

@Mod(value="creativecore")
public class CreativeCore {
    private static final ICreativeLoader LOADER = new CreativeForgeLoader();
    private static final ILoaderUtils UTILS = new ForgeLoaderUtils();
    public static final String MODID = "creativecore";
    public static final Logger LOGGER = LogManager.getLogger((String)"creativecore");
    public static final CreativeCoreConfig CONFIG = new CreativeCoreConfig();
    public static final CreativeNetwork NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation("creativecore", "main"));
    public static ConfigEventHandler CONFIG_HANDLER;
    public static MenuType<ContainerIntegration> GUI_CONTAINER;
    public static final GuiCreator.GuiCreatorBasic CONFIG_OPEN;
    public static final GuiCreator.GuiCreatorBasic CONFIG_CLIENT_SYNC_OPEN;
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES;
    public static final RegistryObject<SingletonArgumentInfo<StringArrayArgumentType>> STRING_ARRAY_ARGUMENT_TYPE;

    public CreativeCore() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerMenus);
        COMMAND_ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::server);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreativeCoreClient.load(FMLJavaModLoadingContext.get().getModEventBus()));
        GUI_CONTAINER = new MenuType<ContainerIntegration>(null){

            public ContainerIntegration create(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }

            public ContainerIntegration create(int windowId, Inventory playerInv) {
                return new ContainerIntegration(this, windowId, playerInv.f_35978_);
            }
        };
    }

    public void registerMenus(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.MENU_TYPES, x -> x.register("container", GUI_CONTAINER));
    }

    private void server(ServerStartingEvent event) {
        event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)Commands.m_82127_((String)"cmdconfig").executes(x -> {
            CONFIG_OPEN.open(new CompoundTag(), (Player)((CommandSourceStack)x.getSource()).m_81375_());
            return 0;
        }));
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ConfigurationChangePacket.class, ConfigurationChangePacket::new);
        NETWORK.registerType(ConfigurationClientPacket.class, ConfigurationClientPacket::new);
        NETWORK.registerType(ConfigurationPacket.class, ConfigurationPacket::new);
        NETWORK.registerType(LayerClosePacket.class, LayerClosePacket::new);
        NETWORK.registerType(LayerOpenPacket.class, LayerOpenPacket::new);
        NETWORK.registerType(OpenGuiPacket.class, OpenGuiPacket::new);
        NETWORK.registerType(ControlSyncPacket.class, ControlSyncPacket::new);
        CONFIG_HANDLER = new ConfigEventHandler(FMLPaths.CONFIGDIR.get().toFile(), LOGGER);
        MinecraftForge.EVENT_BUS.register(GuiEventHandler.class);
        GuiLayerCreator.REGISTRY.register("info", GuiInfoStackButton.INFO_LAYER);
        GuiLayerCreator.REGISTRY.register("player", GuiPlayerSelectorButton.PLAYER_LAYER);
        GuiLayerCreator.REGISTRY.register("dialog", GuiDialogHandler.DIALOG_HANDLER);
    }

    public static ICreativeLoader loader() {
        return LOADER;
    }

    public static ILoaderUtils utils() {
        return UTILS;
    }

    static {
        CONFIG_OPEN = GuiCreator.register("config", new GuiCreator.GuiCreatorBasic((player, nbt) -> new ConfigGuiLayer(CreativeConfigRegistry.ROOT, Side.SERVER)));
        CONFIG_CLIENT_SYNC_OPEN = GuiCreator.register("clientconfig", new GuiCreator.GuiCreatorBasic((player, nbt) -> new ClientSyncGuiLayer(CreativeConfigRegistry.ROOT)));
        COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registry.f_235724_, (String)MODID);
        STRING_ARRAY_ARGUMENT_TYPE = COMMAND_ARGUMENT_TYPES.register("string_array", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(StringArrayArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(() -> StringArrayArgumentType.stringArray())));
    }
}

