/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.modernworldcreation;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.modernworldcreation.ModernWorldCreation;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ToggleModeButton
extends AdvancedButton {
    protected static final ResourceLocation INFO_BACK_TEXTURE = new ResourceLocation("modernworldcreation", "info_back.png");
    protected ResourceLocation texture;
    protected String label;
    protected boolean selected = false;
    protected int animationTicker = 1;
    protected Color labelBackgroundColor;
    public int addToHeightWhenHovered = 10;
    public int labelBackgroundHeight = 16;
    public boolean darkenWhenUnfocused = true;
    public boolean showInfo = true;
    protected AdvancedImageButton infoButton;
    protected Color borderColor;

    public ToggleModeButton(int x, int y, int widthIn, int heightIn, ResourceLocation texture, String label, boolean handleClick, Button.OnPress onPress) {
        super(x, y, widthIn, heightIn, "", handleClick, onPress);
        this.texture = texture;
        this.label = label;
        this.labelBackgroundColor = new Color(0, 0, 0, 140);
        Color c = new Color(0, 0, 0, 0);
        this.setBackgroundColor(c, c, c, c, 0);
        this.infoButton = new AdvancedImageButton(0, 0, 10, 10, INFO_BACK_TEXTURE, press -> {});
        this.infoButton.f_93623_ = false;
        Color infoBack = new Color(0, 0, 0, 255);
        Color infoBorder = new Color(224, 224, 224, 255);
        this.infoButton.setBackgroundColor(infoBack, infoBack, infoBorder, infoBorder, 0.4f);
        this.borderColor = RenderUtils.getColorFromHexString((String)((String)ModernWorldCreation.config.getOrDefault("button_border_hex_color", (Object)"#ffffff")));
        if (this.borderColor == null) {
            this.borderColor = new Color(255, 255, 255, 255);
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        this.infoButton.f_93624_ = this.showInfo;
        int w = this.f_93618_;
        int h = this.f_93619_;
        int x = this.f_93620_;
        int y = this.f_93621_;
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.m_198029_() || this.selected) {
            if (this.animationTicker < this.addToHeightWhenHovered) {
                ++this.animationTicker;
            }
            h += this.animationTicker;
            y -= this.animationTicker / 2;
        } else if (this.animationTicker > 1) {
            h += this.animationTicker;
            y -= this.animationTicker / 2;
            --this.animationTicker;
        }
        this.infoButton.f_93620_ = this.f_93620_ + this.f_93618_ - this.infoButton.m_5711_() - 2;
        this.infoButton.f_93621_ = this.animationTicker > 1 ? this.f_93621_ - this.animationTicker / 2 + 2 : this.f_93621_ + 2;
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        RenderUtils.bindTexture((ResourceLocation)this.texture);
        if (!this.m_198029_() && !this.selected && this.darkenWhenUnfocused) {
            RenderSystem.m_157429_((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        ToggleModeButton.m_93133_((PoseStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)this.f_93618_, (int)(this.f_93619_ + this.addToHeightWhenHovered));
        int backY = y + h - 10 - this.labelBackgroundHeight;
        if (this.animationTicker > 1) {
            backY += this.animationTicker / 2;
        }
        ToggleModeButton.m_93172_((PoseStack)matrix, (int)x, (int)backY, (int)(x + w), (int)(backY + this.labelBackgroundHeight), (int)this.labelBackgroundColor.getRGB());
        String labelString = "\u00a7f\u00a7l" + this.label;
        MutableComponent comp = Component.m_237113_((String)labelString);
        int sWidth = font.m_92852_((FormattedText)comp);
        Objects.requireNonNull(font);
        int sHeight = 9;
        int sX = x + w / 2 - sWidth / 2;
        int sY = y + h - 10 - this.labelBackgroundHeight / 2 - sHeight / 2;
        if (this.animationTicker > 1) {
            sY += this.animationTicker / 2;
        }
        font.m_92877_(matrix, comp.m_7532_(), (float)sX, (float)sY, 0);
        this.renderBorder(matrix);
        if (this.showInfo) {
            this.infoButton.m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderBorder(PoseStack matrix) {
        float thickness = ((Float)ModernWorldCreation.config.getOrDefault("button_border_thickness", (Object)Float.valueOf(0.7f))).floatValue();
        int bY = this.f_93621_;
        int heightOffset = 0;
        if (this.animationTicker > 1) {
            bY -= this.animationTicker / 2;
            heightOffset += this.animationTicker;
        }
        RenderUtils.fill((PoseStack)matrix, (float)this.f_93620_, (float)((float)bY - thickness), (float)(this.f_93620_ + this.f_93618_), (float)bY, (int)this.borderColor.getRGB(), (float)1.0f);
        RenderUtils.fill((PoseStack)matrix, (float)((float)this.f_93620_ - thickness), (float)((float)bY - thickness), (float)this.f_93620_, (float)((float)(bY + this.f_93619_) + thickness + (float)heightOffset), (int)this.borderColor.getRGB(), (float)1.0f);
        RenderUtils.fill((PoseStack)matrix, (float)this.f_93620_, (float)(bY + this.f_93619_ + heightOffset), (float)(this.f_93620_ + this.f_93618_), (float)((float)(bY + this.f_93619_) + thickness + (float)heightOffset), (int)this.borderColor.getRGB(), (float)1.0f);
        RenderUtils.fill((PoseStack)matrix, (float)(this.f_93620_ + this.f_93618_), (float)((float)bY - thickness), (float)((float)(this.f_93620_ + this.f_93618_) + thickness), (float)((float)(bY + this.f_93619_) + thickness + (float)heightOffset), (int)this.borderColor.getRGB(), (float)1.0f);
    }

    public void setImage(ResourceLocation texture) {
        this.texture = texture;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setInfoText(String ... info) {
        this.infoButton.setDescription(info);
    }
}

