/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.features.enchantment.EnchantmentMenuProcess;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableServerEventJS;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventResult;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class EnchantmentTableChangedJS
extends EnchantmentTableServerEventJS {
    private final RandomSource random;

    public EnchantmentTableChangedJS(ItemStack item, ItemStack secondItem, Level level, BlockPos pos, EnchantmentMenuProcess state, RandomSource random) {
        super(item, secondItem, level, pos, state.getPlayer(), state);
        this.random = random;
    }

    protected void afterPosted(EventResult result) {
        super.afterPosted(result);
        for (int i = 0; i < this.getSize(); ++i) {
            MutableData data = this.get(i);
            if (!data.getEnchantments().isEmpty()) continue;
            data.setRequiredLevel(0);
        }
    }

    @Override
    public MutableData get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getSize());
        return new MutableData(index);
    }

    @Override
    public int getSize() {
        return this.state.getMenu().f_39446_.length;
    }

    public class MutableData
    extends EnchantmentTableServerEventJS.Data {
        private MutableData(int index) {
            super(EnchantmentTableChangedJS.this, index);
        }

        public void setRequiredLevel(int level) {
            EnchantmentTableChangedJS.this.state.getMenu().f_39446_[this.index] = level;
        }

        public void updateClue() {
            List<EnchantmentInstance> enchantments = this.getEnchantments();
            EnchantmentInstance instance = enchantments.get(EnchantmentTableChangedJS.this.random.m_188503_(enchantments.size()));
            EnchantmentTableChangedJS.this.menu.f_39447_[this.index] = Registry.f_122825_.m_7447_((Object)instance.f_44947_);
            EnchantmentTableChangedJS.this.menu.f_39448_[this.index] = instance.f_44948_;
        }

        public void removeEnchantments(BiPredicate<Enchantment, Integer> consumer) {
            this.getEnchantments().removeIf(i -> consumer.test(i.f_44947_, i.f_44948_));
        }

        public void addEnchantment(Enchantment enchantment, int level) {
            Objects.requireNonNull(enchantment, "Enchantment does not exist");
            this.getEnchantments().add(new EnchantmentInstance(enchantment, level));
        }
    }
}

