/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities;

import com.infamous.dungeons_libraries.capabilities.minionmaster.FollowerLeaderHelper;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Leader;
import com.infamous.dungeons_libraries.capabilities.playerrewards.PlayerRewards;
import com.infamous.dungeons_libraries.capabilities.playerrewards.PlayerRewardsHelper;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import com.infamous.dungeons_libraries.network.UpdateSoulsMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class CapabilityEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new UpdateSoulsMessage(SoulCasterHelper.getSoulCasterCapability(event.getEntity()).getSouls()));
        }
    }

    @SubscribeEvent
    public static void clonePlayerCaps(PlayerEvent.Clone event) {
        Leader oldLeaderCap = FollowerLeaderHelper.getLeaderCapability((Entity)event.getOriginal());
        Leader newLeaderCap = FollowerLeaderHelper.getLeaderCapability((Entity)event.getEntity());
        newLeaderCap.copyFrom(oldLeaderCap);
        if (!event.isWasDeath() || ((Boolean)DungeonsLibrariesConfig.ENABLE_KEEP_SOULS_ON_DEATH.get()).booleanValue()) {
            SoulCaster oldSoulsCap = SoulCasterHelper.getSoulCasterCapability((Entity)event.getOriginal());
            SoulCaster newSoulsCap = SoulCasterHelper.getSoulCasterCapability((Entity)event.getEntity());
            newSoulsCap.setSouls(oldSoulsCap.getSouls(), (LivingEntity)event.getEntity());
        }
        PlayerRewards oldPlayerRewardsCap = PlayerRewardsHelper.getPlayerRewardsCapability(event.getOriginal());
        PlayerRewards newPlayerRewardsCap = PlayerRewardsHelper.getPlayerRewardsCapability(event.getEntity());
        newPlayerRewardsCap.setPlayerRewards(oldPlayerRewardsCap.getAllPlayerRewards());
    }
}

