/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.elite;

import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantments;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;

public class AttacherEliteMob {
    public static void attach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            EliteMobProvider provider = new EliteMobProvider();
            event.addCapability(EliteMobProvider.IDENTIFIER, (ICapabilityProvider)provider);
        }
    }

    private static class EliteMobProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static final ResourceLocation IDENTIFIER = new ResourceLocation("dungeons_libraries", "elite_mob");
        private final BuiltInEnchantments backend = new BuiltInEnchantments();
        private final LazyOptional<BuiltInEnchantments> optionalData = LazyOptional.of(() -> this.backend);

        private EliteMobProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return ModCapabilities.BUILT_IN_ENCHANTMENTS_CAPABILITY.orEmpty(cap, this.optionalData);
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }
}

