/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Minion;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Follower
implements INBTSerializable<CompoundTag>,
Minion {
    private UUID leaderUUID;
    private ResourceLocation levelOnLoad;
    private LivingEntity leader;
    private boolean summon = false;
    private int followerDuration = 0;
    private boolean temporary = false;
    private boolean revertsOnExpiration = false;
    private boolean goalsAdded = false;
    public static final String LEADER_KEY = "leader";
    public static final String LEVEL_KEY = "level";
    public static final String SUMMON_FLAG_KEY = "is_summon";
    public static final String TEMPORARY_FLAG_KEY = "is_temporary";
    public static final String REVERTS_ON_EXPIRATION_FLAG_KEY = "reverts_on_expiration";
    public static final String FOLLOWER_DURATION_KEY = "follower_duration";

    @Nullable
    public LivingEntity getLeader() {
        if (this.leader == null && this.leaderUUID != null && this.levelOnLoad != null) {
            Entity entity;
            ResourceKey registrykey1 = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)this.levelOnLoad);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                DungeonsLibraries.LOGGER.debug("Tried and failed to query leader by UUID from a Follower with no MinecraftServer present");
                return null;
            }
            ServerLevel world = server.m_129880_(registrykey1);
            if (world != null && (entity = world.m_8791_(this.leaderUUID)) instanceof LivingEntity) {
                this.leader = (LivingEntity)entity;
            }
        }
        return this.leader;
    }

    public void setLeader(@Nullable LivingEntity leader) {
        this.leader = leader;
        if (leader != null) {
            this.leaderUUID = leader.m_20148_();
            this.levelOnLoad = leader.f_19853_.m_46472_().m_135782_();
        } else {
            this.leaderUUID = null;
            this.levelOnLoad = null;
        }
    }

    public void setLeaderUUID(UUID leaderUUID) {
        this.leaderUUID = leaderUUID;
    }

    public void setLevelOnLoad(ResourceLocation levelOnLoad) {
        this.levelOnLoad = levelOnLoad;
    }

    public boolean isFollower() {
        return this.getLeader() != null;
    }

    @Override
    public boolean isSummon() {
        return this.getLeader() != null && this.summon;
    }

    @Override
    public void setSummon(boolean summon) {
        this.summon = summon;
    }

    public void setFollowerDuration(int followerDuration) {
        this.followerDuration = followerDuration;
    }

    public int getFollowerDuration() {
        return this.followerDuration;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Override
    public boolean revertsOnExpiration() {
        return this.revertsOnExpiration;
    }

    @Override
    public void setRevertsOnExpiration(boolean revertsOnExpiration) {
        this.revertsOnExpiration = revertsOnExpiration;
    }

    @Override
    public boolean isGoalsAdded() {
        return this.goalsAdded;
    }

    @Override
    public void setGoalsAdded(boolean goalsAdded) {
        this.goalsAdded = goalsAdded;
    }

    @Nullable
    public CompoundTag serializeNBT() {
        if (ModCapabilities.FOLLOWER_CAPABILITY == null) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        if (this.getLeader() != null) {
            tag.m_128362_(LEADER_KEY, this.leaderUUID);
            ResourceLocation location = this.getLeader().f_19853_.m_46472_().m_135782_();
            tag.m_128359_(LEVEL_KEY, location.toString());
        }
        tag.m_128379_(SUMMON_FLAG_KEY, this.isSummon());
        tag.m_128379_(TEMPORARY_FLAG_KEY, this.isTemporary());
        tag.m_128379_(REVERTS_ON_EXPIRATION_FLAG_KEY, this.revertsOnExpiration());
        tag.m_128405_(FOLLOWER_DURATION_KEY, this.getFollowerDuration());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128403_(LEADER_KEY)) {
            this.setLeaderUUID(tag.m_128342_(LEADER_KEY));
        }
        if (tag.m_128441_(LEVEL_KEY)) {
            this.setLevelOnLoad(new ResourceLocation(tag.m_128461_(LEVEL_KEY)));
        }
        if (tag.m_128441_(SUMMON_FLAG_KEY)) {
            this.setSummon(tag.m_128471_(SUMMON_FLAG_KEY));
        }
        if (tag.m_128441_(TEMPORARY_FLAG_KEY)) {
            this.setTemporary(tag.m_128471_(TEMPORARY_FLAG_KEY));
        }
        if (tag.m_128441_(REVERTS_ON_EXPIRATION_FLAG_KEY)) {
            this.setRevertsOnExpiration(tag.m_128471_(REVERTS_ON_EXPIRATION_FLAG_KEY));
        }
        if (tag.m_128441_(FOLLOWER_DURATION_KEY)) {
            this.setFollowerDuration(tag.m_128451_(FOLLOWER_DURATION_KEY));
        }
    }

    @Override
    @Deprecated(forRemoval=true)
    @Nullable
    public LivingEntity getMaster() {
        return this.getLeader();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void setMaster(LivingEntity master) {
        this.setLeader(master);
    }

    @Override
    @Deprecated(forRemoval=true)
    public boolean isMinion() {
        return this.isFollower();
    }

    @Override
    @Deprecated(forRemoval=true)
    public int getMinionTimer() {
        return this.getFollowerDuration();
    }

    @Override
    @Deprecated(forRemoval=true)
    public void setMinionTimer(int minionTimer) {
        this.setFollowerDuration(minionTimer);
    }
}

