/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.capabilities.minionmaster.Follower;
import com.infamous.dungeons_libraries.capabilities.minionmaster.FollowerLeaderHelper;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Leader;
import com.infamous.dungeons_libraries.utils.AbilityHelper;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class FollowerEvents {
    private static ArmorStand DUMMY_TARGET;

    @SubscribeEvent
    public static void onSetAttackTarget(LivingChangeTargetEvent event) {
        LivingEntity attacker = event.getEntity();
        Level level = attacker.f_19853_;
        LivingEntity target = event.getNewTarget();
        if (attacker instanceof Mob && target instanceof Mob && AbilityHelper.isAlly(attacker, target)) {
            FollowerEvents.createDummyTarget(level);
            if (attacker instanceof NeutralMob) {
                ((NeutralMob)attacker).m_6925_(null);
                ((NeutralMob)attacker).m_7870_(0);
            }
            ((Mob)attacker).m_6710_((LivingEntity)DUMMY_TARGET);
            attacker.m_6703_((LivingEntity)DUMMY_TARGET);
        }
    }

    private static void createDummyTarget(Level level) {
        if (DUMMY_TARGET == null && (DUMMY_TARGET = (ArmorStand)EntityType.f_20529_.m_20615_(level)) != null) {
            DUMMY_TARGET.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entityLiving = event.getEntity();
        if (entityLiving.f_19853_.f_46443_) {
            return;
        }
        Follower cap = FollowerLeaderHelper.getFollowerCapability((Entity)entityLiving);
        if (cap.isFollower() && cap.isTemporary()) {
            if (cap.getFollowerDuration() > 0) {
                cap.setFollowerDuration(cap.getFollowerDuration() - 1);
            } else if (cap.revertsOnExpiration()) {
                FollowerLeaderHelper.removeFollower(entityLiving);
            } else {
                entityLiving.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    @SubscribeEvent
    public static void reAddFollowerGoals(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!event.getLevel().m_5776_() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Leader leaderCapability = FollowerLeaderHelper.getLeaderCapability(entity);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                FollowerLeaderHelper.addFollowerGoals(mob);
            }
            List<Entity> minions = leaderCapability.getAllMinions();
            for (Entity minion : minions) {
                if (!(minion instanceof Mob)) continue;
                Follower minionCapability = FollowerLeaderHelper.getFollowerCapability(minion);
                minionCapability.setLeader(livingEntity);
                FollowerLeaderHelper.addFollowerGoals((Mob)minion);
            }
        }
    }

    @SubscribeEvent
    public static void checkSummonedMobIsDead(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.CLIENT) {
            return;
        }
        if (!player.m_6084_()) {
            return;
        }
        Leader leaderCap = FollowerLeaderHelper.getLeaderCapability((Entity)event.player);
        FollowerEvents.updateAliveList(leaderCap);
    }

    @SubscribeEvent
    public static void onFollowerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        Follower FollowerCapability;
        LivingEntity summoner;
        if (!event.getEntity().f_19853_.m_5776_() && FollowerLeaderHelper.isFollower((Entity)event.getEntity()) && (summoner = (FollowerCapability = FollowerLeaderHelper.getFollowerCapability((Entity)(livingEntity = event.getEntity()))).getLeader()) != null) {
            Leader leaderCapability = FollowerLeaderHelper.getLeaderCapability((Entity)summoner);
            FollowerEvents.updateAliveList(leaderCapability);
        }
    }

    private static void updateAliveList(Leader leader) {
        List<Entity> aliveSummons = leader.getSummonedMobs().stream().filter(entity -> entity != null && entity.m_6084_()).collect(Collectors.toList());
        leader.setSummonedMobs(aliveSummons);
        List<Entity> aliveMinions = leader.getOtherMinions().stream().filter(entity -> entity != null && entity.m_6084_()).collect(Collectors.toList());
        leader.setOtherMinions(aliveMinions);
    }
}

