/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.minionmaster;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Follower;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Leader;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.FollowerFollowLeaderGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.LeaderHurtByTargetGoal;
import com.infamous.dungeons_libraries.capabilities.minionmaster.goals.LeaderHurtTargetGoal;
import com.infamous.dungeons_libraries.mixin.MobInvoker;
import com.infamous.dungeons_libraries.summon.SummonHelper;
import com.infamous.dungeons_libraries.utils.AbilityHelper;
import com.infamous.dungeons_libraries.utils.PetHelper;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Monster;

public class FollowerLeaderHelper {
    public static Leader getLeaderCapability(Entity entity) {
        return (Leader)entity.getCapability(ModCapabilities.LEADER_CAPABILITY).orElse((Object)new Leader());
    }

    public static Follower getFollowerCapability(Entity entity) {
        return (Follower)entity.getCapability(ModCapabilities.FOLLOWER_CAPABILITY).orElse((Object)new Follower());
    }

    @Nullable
    public static LivingEntity getOwnerForHorse(AbstractHorse horseEntity) {
        try {
            if (horseEntity.m_30615_() != null) {
                UUID ownerUniqueId = horseEntity.m_30615_();
                return ownerUniqueId == null ? null : horseEntity.f_19853_.m_46003_(ownerUniqueId);
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public static boolean isFollower(Entity target) {
        return FollowerLeaderHelper.getFollowerCapability(target).getLeader() != null;
    }

    public static boolean isFollowerOf(LivingEntity target, LivingEntity owner) {
        Follower targetSummonableCap = FollowerLeaderHelper.getFollowerCapability((Entity)target);
        return targetSummonableCap.getLeader() != null && targetSummonableCap.getLeader() == owner;
    }

    @Nullable
    public static LivingEntity getLeader(LivingEntity minionMob) {
        Follower minion = FollowerLeaderHelper.getFollowerCapability((Entity)minionMob);
        return minion.getLeader();
    }

    public static boolean isSuitableNavigationForFollowLeader(Mob mobEntity) {
        return mobEntity.m_21573_() instanceof GroundPathNavigation || mobEntity.m_21573_() instanceof FlyingPathNavigation;
    }

    private void makeFollowerOf(LivingEntity livingEntity, LivingEntity nearbyEntity) {
        if (nearbyEntity instanceof Monster) {
            Monster mobEntity = (Monster)nearbyEntity;
            Leader leaderCapability = FollowerLeaderHelper.getLeaderCapability((Entity)livingEntity);
            Follower minionCapability = FollowerLeaderHelper.getFollowerCapability((Entity)nearbyEntity);
            leaderCapability.addFollower((Entity)mobEntity);
            minionCapability.setLeader(livingEntity);
            minionCapability.setGoalsAdded(false);
            ((Monster)nearbyEntity).m_6710_(null);
            FollowerLeaderHelper.addFollowerGoals((Mob)mobEntity);
        }
    }

    private void makeTemporaryFollowerOf(LivingEntity livingEntity, LivingEntity nearbyEntity, int followerDuration, boolean revertsOnExpiration) {
        if (nearbyEntity instanceof Mob) {
            Mob mob = (Mob)nearbyEntity;
            Leader leaderCapability = FollowerLeaderHelper.getLeaderCapability((Entity)livingEntity);
            Follower minionCapability = FollowerLeaderHelper.getFollowerCapability((Entity)nearbyEntity);
            leaderCapability.addFollower((Entity)mob);
            minionCapability.setLeader(livingEntity);
            minionCapability.setTemporary(true);
            minionCapability.setRevertsOnExpiration(revertsOnExpiration);
            minionCapability.setFollowerDuration(followerDuration);
            minionCapability.setGoalsAdded(false);
            mob.m_6710_(null);
            FollowerLeaderHelper.addFollowerGoals(mob);
        }
    }

    public static void addFollowerGoals(Mob mobEntity) {
        Follower minionCap = FollowerLeaderHelper.getFollowerCapability((Entity)mobEntity);
        if (minionCap.isGoalsAdded()) {
            return;
        }
        if (minionCap.isFollower()) {
            if (!FollowerLeaderHelper.isSuitableNavigationForFollowLeader(mobEntity)) {
                DungeonsLibraries.LOGGER.error("Unsupported mob type for FollowerFollowLeaderGoal: {}", (Object)mobEntity.m_6095_());
                return;
            }
            mobEntity.f_21345_.m_25352_(2, (Goal)new FollowerFollowLeaderGoal(mobEntity, 1.5, 24.0f, 3.0f, false));
            FollowerLeaderHelper.clearGoals(mobEntity.f_21346_);
            mobEntity.f_21346_.m_25352_(1, (Goal)new LeaderHurtByTargetGoal(mobEntity));
            mobEntity.f_21346_.m_25352_(2, (Goal)new LeaderHurtTargetGoal(mobEntity));
            mobEntity.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal(mobEntity, LivingEntity.class, 5, false, false, entityIterator -> AbilityHelper.isDefaultEnemy(entityIterator) && PetHelper.canPetAttackEntity((LivingEntity)mobEntity, entityIterator)));
            minionCap.getLeader().getCapability(ModCapabilities.LEADER_CAPABILITY).ifPresent(leader -> leader.addFollower((Entity)mobEntity));
            SummonHelper.addSummonGoals(mobEntity);
            minionCap.setGoalsAdded(true);
        }
    }

    public static void removeFollower(LivingEntity entityLiving) {
        Follower cap = FollowerLeaderHelper.getFollowerCapability((Entity)entityLiving);
        LivingEntity leader = cap.getLeader();
        Leader leaderCapability = FollowerLeaderHelper.getLeaderCapability((Entity)leader);
        leaderCapability.removeMinion(entityLiving);
        cap.setLeader(null);
        if (entityLiving instanceof Mob) {
            Mob mobEntity = (Mob)entityLiving;
            FollowerLeaderHelper.clearGoals(mobEntity.f_21345_);
            FollowerLeaderHelper.clearGoals(mobEntity.f_21346_);
            cap.setGoalsAdded(false);
            ((MobInvoker)entityLiving).invokeRegisterGoals();
        }
    }

    private static void clearGoals(GoalSelector goalSelector) {
        ArrayList<WrappedGoal> wrappedGoals = new ArrayList<WrappedGoal>(goalSelector.m_148105_());
        wrappedGoals.forEach(prioritizedGoal -> goalSelector.m_25363_(prioritizedGoal.m_26015_()));
    }
}

