/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.playerrewards;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerRewards
implements INBTSerializable<CompoundTag> {
    private Map<ResourceLocation, Integer> rewards = new HashMap<ResourceLocation, Integer>();

    public boolean addPlayerReward(ResourceLocation source) {
        this.rewards.put(source, this.rewards.computeIfAbsent(source, resourceLocation -> 1) + 1);
        return true;
    }

    public boolean removePlayerReward(ResourceLocation source) {
        if (!this.rewards.containsKey(source) || this.rewards.get(source) == 0) {
            return true;
        }
        this.rewards.put(source, this.rewards.get(source) - 1);
        return true;
    }

    public boolean setPlayerRewards(ResourceLocation source, Integer amount) {
        this.rewards.put(source, amount);
        return true;
    }

    public Integer getPlayerRewardAmount(ResourceLocation source) {
        return this.rewards.getOrDefault(source, 0);
    }

    public boolean hasPlayerReward(ResourceLocation source) {
        return this.rewards.containsKey(source) && this.rewards.get(source) > 0;
    }

    public Map<ResourceLocation, Integer> getAllPlayerRewards() {
        return new HashMap<ResourceLocation, Integer>(this.rewards);
    }

    public boolean setPlayerRewards(Map<ResourceLocation, Integer> allPlayerRewards) {
        this.rewards = new HashMap<ResourceLocation, Integer>(allPlayerRewards);
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        Map<ResourceLocation, Integer> rewards = this.getAllPlayerRewards();
        ListTag listNBT = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : rewards.entrySet()) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128359_("source", entry.getKey().toString());
            compoundNBT.m_128405_("amount", entry.getValue().intValue());
            listNBT.add((Object)compoundNBT);
        }
        nbt.m_128365_("rewards", (Tag)listNBT);
        return nbt;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag listNBT = tag.m_128437_("rewards", 10);
        for (Tag inbt : listNBT) {
            if (!(inbt instanceof CompoundTag)) continue;
            CompoundTag compoundNBT1 = (CompoundTag)inbt;
            ResourceLocation resourceLocation = new ResourceLocation(compoundNBT1.m_128461_("source"));
            Integer amount = compoundNBT1.m_128451_("amount");
            this.setPlayerRewards(resourceLocation, amount);
        }
    }
}

