/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.capabilities.timers;

import com.infamous.dungeons_libraries.capabilities.ModCapabilities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class Timers
implements INBTSerializable<CompoundTag> {
    private final Map<ResourceLocation, Integer> enchantmentTimers = new HashMap<ResourceLocation, Integer>();
    public static final String ENCHANTS_KEY = "EnchantmentTimers";
    public static final String ENCHANTMENT_KEY = "Enchantment";
    public static final String TIMER_KEY = "Timer";

    public int getEnchantmentTimer(Enchantment enchantment) {
        return this.enchantmentTimers.computeIfAbsent(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment), resourceLocation -> -1);
    }

    public boolean setEnchantmentTimer(Enchantment enchantment, int value) {
        this.enchantmentTimers.put(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment), value);
        return true;
    }

    public boolean setEnchantmentTimer(ResourceLocation enchantment, int value) {
        this.enchantmentTimers.put(enchantment, value);
        return true;
    }

    public boolean tickTimers() {
        this.enchantmentTimers.replaceAll((resourceLocation, integer) -> integer > 0 ? integer - 1 : integer);
        return true;
    }

    public Map<ResourceLocation, Integer> getEnchantmentTimers() {
        return this.enchantmentTimers;
    }

    public CompoundTag serializeNBT() {
        if (ModCapabilities.TIMERS_CAPABILITY == null) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        ListTag listnbt = new ListTag();
        this.getEnchantmentTimers().forEach((resourceLocation, timer) -> {
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128359_(ENCHANTMENT_KEY, resourceLocation.toString());
            compoundnbt.m_128405_(TIMER_KEY, timer.intValue());
            listnbt.add((Object)compoundnbt);
        });
        tag.m_128365_(ENCHANTS_KEY, (Tag)listnbt);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag listNBT = tag.m_128437_(ENCHANTS_KEY, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundTag compoundnbt = listNBT.m_128728_(i);
            ResourceLocation resourcelocation = ResourceLocation.m_135820_((String)compoundnbt.m_128461_(ENCHANTMENT_KEY));
            int timer = compoundnbt.m_128451_(TIMER_KEY);
            this.setEnchantmentTimer(resourcelocation, timer);
        }
    }
}

