/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.data.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MergeableCodecDataManager<RAW, FINE>
extends SimplePreparableReloadListener<Map<ResourceLocation, FINE>> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    protected Map<ResourceLocation, FINE> data = new HashMap<ResourceLocation, FINE>();
    private final String folderName;
    private final Codec<RAW> codec;
    private final Function<List<RAW>, FINE> merger;

    public MergeableCodecDataManager(String folderName, Codec<RAW> codec, Function<List<RAW>, FINE> merger) {
        this.folderName = folderName;
        this.codec = codec;
        this.merger = merger;
    }

    public Map<ResourceLocation, FINE> getData() {
        return this.data;
    }

    protected Map<ResourceLocation, FINE> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        LOGGER.info("Beginning loading of data for data loader: {}", (Object)this.folderName);
        HashMap<ResourceLocation, FINE> map = new HashMap<ResourceLocation, FINE>();
        Map resourceStacks = resourceManager.m_214160_(this.folderName, id -> id.m_135815_().endsWith(JSON_EXTENSION));
        for (Map.Entry entry : resourceStacks.entrySet()) {
            ArrayList raws = new ArrayList();
            ResourceLocation fullId = (ResourceLocation)entry.getKey();
            String fullPath = fullId.m_135815_();
            ResourceLocation id2 = new ResourceLocation(fullId.m_135827_(), fullPath.substring(this.folderName.length() + 1, fullPath.length() - JSON_EXTENSION_LENGTH));
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(errorMsg -> LOGGER.error("Error deserializing json {} in folder {} from pack {}: {}", (Object)id2, (Object)this.folderName, (Object)resource.m_215506_(), errorMsg)).ifPresent(raws::add);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format(Locale.ENGLISH, "Error reading resource %s in folder %s from pack %s: ", id2, this.folderName, resource.m_215506_()), (Throwable)e);
                }
            }
            map.put(id2, this.merger.apply(raws));
        }
        LOGGER.info("Data loader for {} loaded {} finalized objects", (Object)this.folderName, (Object)this.data.size());
        return ImmutableMap.copyOf(map);
    }

    protected void apply(Map<ResourceLocation, FINE> processedData, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.data = processedData;
    }

    public <PACKET> MergeableCodecDataManager<RAW, FINE> subscribeAsSyncable(SimpleChannel channel, Function<Map<ResourceLocation, FINE>, PACKET> packetFactory) {
        MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(channel, packetFactory));
        return this;
    }

    private <PACKET> Consumer<OnDatapackSyncEvent> getDatapackSyncListener(SimpleChannel channel, Function<Map<ResourceLocation, FINE>, PACKET> packetFactory) {
        return event -> {
            ServerPlayer player = event.getPlayer();
            Object packet = packetFactory.apply(this.data);
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            channel.send(target, packet);
        };
    }
}

