/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.entities;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TotemBaseEntity
extends Entity {
    private final TargetingConditions entityTargeting = TargetingConditions.m_148352_().m_26883_(8.0).m_148355_().m_26893_();
    protected int lifeTicks = 80;
    protected int deathTicks = 40;
    private float totemDeathAnimationO;
    private float totemDeathAnimation;
    private LivingEntity owner;
    private UUID ownerUUID;

    public TotemBaseEntity(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public TotemBaseEntity(EntityType<?> p_i48580_1_, Level p_i48580_2_, int lifeTicks, int deathTicks) {
        super(p_i48580_1_, p_i48580_2_);
        this.lifeTicks = lifeTicks;
        this.deathTicks = deathTicks;
    }

    protected void m_8097_() {
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public void setLifeTicks(int lifeTicks) {
        this.lifeTicks = lifeTicks;
    }

    public boolean isTotemDeath() {
        return this.lifeTicks <= 0;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.totemDeathAnimationO = this.totemDeathAnimation;
            this.totemDeathAnimation = this.isTotemDeath() ? Mth.m_14036_((float)(this.totemDeathAnimation + 0.1f), (float)0.0f, (float)1.0f) : Mth.m_14036_((float)(this.totemDeathAnimation - 0.1f), (float)0.0f, (float)1.0f);
        }
        if (this.lifeTicks > 0) {
            --this.lifeTicks;
            this.applyTotemEffect();
        } else if (this.deathTicks > 0) {
            --this.deathTicks;
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected abstract void applyTotemEffect();

    @OnlyIn(value=Dist.CLIENT)
    public float getTotemDeathAnimationScale(float p_189795_1_) {
        return Mth.m_14179_((float)p_189795_1_, (float)this.totemDeathAnimationO, (float)this.totemDeathAnimation);
    }

    public void setOwner(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("LifeTicks", 99)) {
            this.lifeTicks = pCompound.m_128451_("LifeTicks");
        }
        if (pCompound.m_128425_("DeathTicks", 99)) {
            this.deathTicks = pCompound.m_128451_("DeathTicks");
        }
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("LifeTicks", this.lifeTicks);
        pCompound.m_128405_("DeathTicks", this.deathTicks);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }
}

