/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.integration.curios.client;

import com.infamous.dungeons_libraries.integration.curios.client.message.CuriosArtifactStartMessage;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactUseContext;
import com.infamous.dungeons_libraries.network.NetworkHandler;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod.EventBusSubscriber(modid="dungeons_libraries", value={Dist.CLIENT})
public class CuriosKeyBindings {
    private static final double RAYTRACE_DISTANCE = 30.0;
    public static final KeyMapping activateArtifact1 = new KeyMapping("key.dungeons_libraries.curiosintegration.description_slot1", 86, "key.dungeons_libraries.curiosintegration.category");
    public static final KeyMapping activateArtifact2 = new KeyMapping("key.dungeons_libraries.curiosintegration.description_slot2", 66, "key.dungeons_libraries.curiosintegration.category");
    public static final KeyMapping activateArtifact3 = new KeyMapping("key.dungeons_libraries.curiosintegration.description_slot3", 78, "key.dungeons_libraries.curiosintegration.category");

    @SubscribeEvent
    public static void onClientTick(InputEvent.Key event) {
        if (activateArtifact1.m_90859_()) {
            CuriosKeyBindings.sendCuriosStartMessageToServer(0);
        }
        if (activateArtifact2.m_90859_()) {
            CuriosKeyBindings.sendCuriosStartMessageToServer(1);
        }
        if (activateArtifact3.m_90859_()) {
            CuriosKeyBindings.sendCuriosStartMessageToServer(2);
        }
    }

    private static void sendCuriosStartMessageToServer(int slot) {
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
                BlockHitResult blockHitResult = new BlockHitResult(player.m_20182_(), Direction.UP, player.m_20183_(), false);
                CuriosKeyBindings.curiosStartMessage(slot, blockHitResult, player);
            } else if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                CuriosKeyBindings.curiosStartMessage(slot, (BlockHitResult)hitResult, player);
            } else if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                BlockHitResult blockHitResult = new BlockHitResult(entityHitResult.m_82443_().m_20182_(), Direction.UP, entityHitResult.m_82443_().m_20183_(), false);
                CuriosKeyBindings.curiosStartMessage(slot, blockHitResult, player);
            }
        }
    }

    private static void curiosStartMessage(int slot, BlockHitResult blockHitResult, LocalPlayer player) {
        NetworkHandler.INSTANCE.sendToServer((Object)new CuriosArtifactStartMessage(slot, blockHitResult));
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
            ItemStack artifact;
            Optional artifactStackHandler = iCuriosItemHandler.getStacksHandler("artifact");
            if (artifactStackHandler.isPresent() && !(artifact = ((ICurioStacksHandler)artifactStackHandler.get()).getStacks().getStackInSlot(slot)).m_41619_() && artifact.m_41720_() instanceof ArtifactItem) {
                ArtifactUseContext iuc = new ArtifactUseContext(player.f_19853_, (Player)player, artifact, blockHitResult);
                ((ArtifactItem)artifact.m_41720_()).activateArtifact(iuc);
            }
        });
    }

    private static BlockHitResult getBlockHitResult(AbstractClientPlayer player) {
        AABB rayTraceBoundingBox;
        Vec3 eyeVector = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20252_(1.0f);
        Vec3 rayTraceVector = eyeVector.m_82520_(lookVector.f_82479_ * 30.0, lookVector.f_82480_ * 30.0, lookVector.f_82481_ * 30.0);
        EntityHitResult entityRTR = ProjectileUtil.m_37304_((Level)player.f_19853_, (Entity)player, (Vec3)eyeVector, (Vec3)rayTraceVector, (AABB)(rayTraceBoundingBox = player.m_20191_().m_82369_(lookVector.m_82490_(30.0)).m_82377_(1.0, 1.0, 1.0)), entity -> entity instanceof LivingEntity && !entity.m_5833_() && entity.m_6087_());
        if (entityRTR != null) {
            return new BlockHitResult(entityRTR.m_82443_().m_20182_(), Direction.UP, entityRTR.m_82443_().m_20183_(), false);
        }
        BlockHitResult blockRTR = (BlockHitResult)player.m_19907_(30.0, 1.0f, false);
        return blockRTR;
    }
}

