/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import java.util.UUID;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class ItemEvents {
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    @SubscribeEvent
    public static void onMagicDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        AttributeInstance magicDamageMultiplierAttribute;
        double attributeModifier;
        float originalDamage;
        double additionalDamage;
        if (event.getSource() instanceof IndirectEntityDamageSource && event.getSource().m_19387_() && event.getSource().m_7639_() instanceof LivingEntity && (additionalDamage = (double)(originalDamage = event.getAmount()) * (attributeModifier = (magicDamageMultiplierAttribute = (attacker = (LivingEntity)event.getSource().m_7639_()).m_21051_((Attribute)AttributeRegistry.MAGIC_DAMAGE_MULTIPLIER.get())) != null ? magicDamageMultiplierAttribute.m_22135_() : 1.0)) > 0.0) {
            event.setAmount(originalDamage + (float)additionalDamage);
        }
    }

    @SubscribeEvent
    public static void onEntityKilled(LivingDeathEvent event) {
        LivingEntity attacker;
        AttributeInstance attribute;
        if (event.getSource().m_7639_() instanceof LivingEntity && (attribute = (attacker = (LivingEntity)event.getSource().m_7639_()).m_21051_((Attribute)AttributeRegistry.LIFE_STEAL.get())) != null) {
            double lifeStealAmount = attribute.m_22135_() - 1.0;
            float victimMaxHealth = event.getEntity().m_21233_();
            if (attacker.m_21223_() < attacker.m_21233_()) {
                attacker.m_5634_(victimMaxHealth * (float)lifeStealAmount);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onItemAttributeModifierEvent(ItemAttributeModifierEvent event) {
    }
}

