/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.ArmorGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IArmor;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.ArmorItemAccessor;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

public class ArmorGear
extends GeoArmorItem
implements IReloadableGear,
IArmor,
IUniqueGear,
IAnimatable {
    private static final ResourceLocation DEFAULT_ARMOR_ANIMATIONS = new ResourceLocation("dungeons_libraries", "animations/armor/armor_default.animation.json");
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private ArmorGearConfig armorGearConfig;
    private final ResourceLocation armorSet;
    private final ResourceLocation modelLocation;
    private final ResourceLocation textureLocation;
    private final ResourceLocation animationFileLocation;
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ArmorGear(EquipmentSlot slotType, Item.Properties properties, ResourceLocation armorSet, ResourceLocation modelLocation, ResourceLocation textureLocation, ResourceLocation animationFileLocation) {
        super((ArmorMaterial)ArmorMaterials.CHAIN, slotType, properties);
        this.armorSet = armorSet;
        this.modelLocation = modelLocation;
        this.textureLocation = textureLocation;
        this.animationFileLocation = animationFileLocation;
        this.reload();
    }

    @Override
    public void reload() {
        this.armorGearConfig = ArmorGearConfigRegistry.getConfig(this.armorSet);
        if (this.armorGearConfig == ArmorGearConfig.DEFAULT) {
            this.armorGearConfig = ArmorGearConfigRegistry.getConfig(ForgeRegistries.ITEMS.getKey((Object)this));
        }
        ArmorMaterial material = this.armorGearConfig.getArmorMaterial();
        ((ArmorItemAccessor)((Object)this)).setMaterial(material);
        ((ArmorItemAccessor)((Object)this)).setDefense(material.m_7365_(this.f_40377_));
        ((ArmorItemAccessor)((Object)this)).setToughness(material.m_6651_());
        ((ArmorItemAccessor)((Object)this)).setKnockbackResistance(material.m_6649_());
        ((ItemAccessor)((Object)this)).setMaxDamage(material.m_7366_(this.f_40377_));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID primaryUuid = ARMOR_MODIFIER_UUID_PER_SLOT[this.f_40377_.m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(primaryUuid, "Armor modifier", (double)material.m_7365_(this.f_40377_), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(primaryUuid, "Armor toughness", (double)material.m_6651_(), AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(primaryUuid, "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        this.armorGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Armor modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
    }

    public ArmorGearConfig getGearConfig() {
        return this.armorGearConfig;
    }

    @Override
    public boolean isUnique() {
        return this.armorGearConfig.isUnique();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == this.f_40377_ ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        if (this.armorSet != null) {
            DescriptionHelper.addLoreDescription(list, this.armorSet);
        } else {
            DescriptionHelper.addLoreDescription(list, ForgeRegistries.ITEMS.getKey((Object)this));
        }
    }

    public Rarity m_41460_(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    public ResourceLocation getArmorSet() {
        return this.armorSet;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public ResourceLocation getAnimationFileLocation() {
        return this.animationFileLocation;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return GeoArmorRenderer.getRenderer(ArmorGear.class, (Entity)entityLiving).applyEntityStats(_default).setCurrentItem(entityLiving, itemStack, armorSlot).applySlot(armorSlot);
            }
        });
    }
}

