/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.infamous.dungeons_libraries.data.Codecs;
import com.infamous.dungeons_libraries.items.gearconfig.GearConfigAttributeModifier;
import com.infamous.dungeons_libraries.items.materials.armor.DungeonsArmorMaterials;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class ArmorGearConfig {
    public static final ArmorGearConfig DEFAULT = new ArmorGearConfig(new ArrayList<GearConfigAttributeModifier>(), new ArrayList<EnchantmentInstance>(), new ResourceLocation("minecraft:iron"), false, Rarity.COMMON);
    public static final Codec<ArmorGearConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GearConfigAttributeModifier.CODEC.listOf().optionalFieldOf("attributes", new ArrayList()).forGetter(ArmorGearConfig::getAttributes), (App)Codecs.ENCHANTMENT_DATA_CODEC.listOf().optionalFieldOf("built_in_enchantments", new ArrayList()).forGetter(ArmorGearConfig::getBuiltInEnchantments), (App)ResourceLocation.f_135803_.fieldOf("material").forGetter(armorGearConfig -> armorGearConfig.materialResource), (App)Codec.BOOL.optionalFieldOf("unique", (Object)false).forGetter(ArmorGearConfig::isUnique), (App)Codecs.ITEM_RARITY_CODEC.fieldOf("rarity").forGetter(ArmorGearConfig::getRarity)).apply((Applicative)instance, ArmorGearConfig::new));
    private final List<GearConfigAttributeModifier> attributes;
    private final List<EnchantmentInstance> builtInEnchantments;
    private final ResourceLocation materialResource;
    private final boolean unique;
    private final Rarity rarity;

    public ArmorGearConfig(List<GearConfigAttributeModifier> attributes, List<EnchantmentInstance> builtInEnchantments, ResourceLocation materialResource, boolean unique, Rarity rarity) {
        this.attributes = attributes;
        this.builtInEnchantments = builtInEnchantments;
        this.materialResource = materialResource;
        this.unique = unique;
        this.rarity = rarity;
    }

    public List<GearConfigAttributeModifier> getAttributes() {
        return this.attributes;
    }

    public List<EnchantmentInstance> getBuiltInEnchantments() {
        return this.builtInEnchantments;
    }

    public ArmorMaterial getArmorMaterial() {
        return DungeonsArmorMaterials.getArmorMaterial(this.materialResource);
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Rarity getRarity() {
        return this.rarity;
    }
}

