/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.event.CrossbowEvent;
import com.infamous.dungeons_libraries.items.gearconfig.BowGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IRangedWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.CrossbowItemInvoker;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrossbowGear
extends CrossbowItem
implements IRangedWeapon,
IReloadableGear,
IUniqueGear {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private BowGearConfig crossbowGearConfig;

    public CrossbowGear(Item.Properties builder) {
        super(builder.m_41503_(384));
        this.reload();
    }

    @Override
    public void reload() {
        this.crossbowGearConfig = CrossbowGearConfigRegistry.getConfig(ForgeRegistries.ITEMS.getKey((Object)this));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.crossbowGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                if (Attributes.f_22281_.equals(attribute)) {
                    uuid = f_41374_;
                } else if (Attributes.f_22283_.equals(attribute)) {
                    uuid = f_41375_;
                }
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Weapon modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
        ((ItemAccessor)((Object)this)).setMaxDamage(this.crossbowGearConfig.getDurability());
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public float getDefaultChargeTime() {
        return this.crossbowGearConfig.getDefaultChargeTime();
    }

    public void m_5929_(Level world, LivingEntity livingEntity, ItemStack stack, int timeLeft) {
        if (!world.f_46443_) {
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            CrossbowItemInvoker crossbowItemInvoker = (CrossbowItemInvoker)((Object)this);
            SoundEvent quickChargeSoundEvent = crossbowItemInvoker.callGetStartSound(quickChargeLevel);
            SoundEvent loadingMiddleSoundEvent = quickChargeLevel == 0 ? SoundEvents.f_11842_ : null;
            float chargeTime = (float)(stack.m_41779_() - timeLeft) / this.getCrossbowChargeTime(livingEntity, stack);
            if (chargeTime < 0.2f) {
                crossbowItemInvoker.setStartSoundPlayed(false);
                crossbowItemInvoker.setMidLoadSoundPlayed(false);
            }
            if (chargeTime >= 0.2f && !crossbowItemInvoker.getStartSoundPlayed() && chargeTime < 1.0f) {
                crossbowItemInvoker.setStartSoundPlayed(true);
                world.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), quickChargeSoundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (chargeTime >= 0.5f && loadingMiddleSoundEvent != null && !crossbowItemInvoker.getMidLoadSoundPlayed() && chargeTime < 1.0f) {
                crossbowItemInvoker.setMidLoadSoundPlayed(true);
                world.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), loadingMiddleSoundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity livingEntity, int timeLeft) {
        float chargeTime = this.getCrossbowChargeTime(livingEntity, stack) + 3.0f - (float)timeLeft;
        float getCharge = this.getCrossbowCharge(livingEntity, chargeTime, stack);
        if (getCharge >= 1.0f && !CrossbowGear.m_40932_((ItemStack)stack) && CrossbowItemInvoker.callTryLoadProjectiles(livingEntity, stack)) {
            CrossbowGear.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource soundSource = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            worldIn.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11841_, soundSource, 1.0f, 1.0f / (livingEntity.m_217043_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public float getCrossbowCharge(LivingEntity livingEntity, float useTime, ItemStack stack) {
        float crossbowChargeTime = this.getCrossbowChargeTime(livingEntity, stack);
        float charge = useTime / crossbowChargeTime;
        if (charge > 1.0f) {
            charge = 1.0f;
        }
        return charge;
    }

    public float getCrossbowChargeTime(@Nullable LivingEntity livingEntity, ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float minTime = 1.0f;
        CrossbowEvent.ChargeTime event = new CrossbowEvent.ChargeTime(livingEntity, stack, this.getDefaultChargeTime());
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(event.getChargeTime() - (float)(5 * quickChargeLevel), minTime);
    }

    public int m_8105_(ItemStack stack) {
        return (int)this.getCrossbowChargeTime(null, stack) + 3;
    }

    public Rarity m_41460_(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isUnique() {
        return this.crossbowGearConfig.isUnique();
    }

    public BowGearConfig getGearConfig() {
        return this.crossbowGearConfig;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        DescriptionHelper.addFullDescription(list, stack);
    }
}

