/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfig;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfigRegistry;
import com.infamous.dungeons_libraries.items.interfaces.IComboWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IMeleeWeapon;
import com.infamous.dungeons_libraries.items.interfaces.IReloadableGear;
import com.infamous.dungeons_libraries.items.interfaces.IUniqueGear;
import com.infamous.dungeons_libraries.mixin.ItemAccessor;
import com.infamous.dungeons_libraries.mixin.TieredItemAccessor;
import com.infamous.dungeons_libraries.utils.DescriptionHelper;
import com.infamous.dungeons_libraries.utils.MojankHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class MeleeGear
extends TieredItem
implements IMeleeWeapon,
IComboWeapon,
Vanishable,
IReloadableGear,
IUniqueGear {
    private Multimap<Attribute, AttributeModifier> defaultModifiers;
    private MeleeGearConfig meleeGearConfig;
    private float attackDamage;

    public MeleeGear(Item.Properties properties) {
        super((Tier)Tiers.WOOD, properties);
        this.reload();
    }

    @Override
    public void reload() {
        this.meleeGearConfig = MeleeGearConfigRegistry.getConfig(ForgeRegistries.ITEMS.getKey((Object)this));
        ((TieredItemAccessor)((Object)this)).setTier(this.meleeGearConfig.getWeaponMaterial());
        ((ItemAccessor)((Object)this)).setMaxDamage(this.m_43314_().m_6609_());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.meleeGearConfig.getAttributes().forEach(attributeModifier -> {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attributeModifier.getAttributeResourceLocation());
            if (attribute != null) {
                UUID uuid = UUID.randomUUID();
                if (Attributes.f_22281_.equals(attribute)) {
                    uuid = f_41374_;
                    this.attackDamage = (float)attributeModifier.getAmount() + this.m_43314_().m_6631_();
                } else if (Attributes.f_22283_.equals(attribute)) {
                    uuid = f_41375_;
                }
                builder.put((Object)attribute, (Object)new AttributeModifier(uuid, "Weapon modifier", attributeModifier.getAmount(), attributeModifier.getOperation()));
            }
        });
        this.defaultModifiers = builder.build();
    }

    public MeleeGearConfig getGearConfig() {
        return this.meleeGearConfig;
    }

    @Override
    public int getComboLength(ItemStack stack, LivingEntity attacker) {
        return this.getGearConfig().getComboLength();
    }

    @Override
    public boolean isUnique() {
        return this.meleeGearConfig.isUnique();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, world, list, flag);
        DescriptionHelper.addFullDescription(list, stack);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.getGearConfig().isDisablesShield();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, MojankHelper::hurtEnemyBroadcastBreakEvent);
        return true;
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !pPlayer.m_7500_();
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        if (blockState.m_60800_((BlockGetter)level, blockPos) != 0.0f) {
            itemStack.m_41622_(1, livingEntity, MojankHelper::hurtEnemyBroadcastBreakEvent);
        }
        return true;
    }

    public boolean m_8096_(BlockState p_150897_1_) {
        return p_150897_1_.m_60713_(Blocks.f_50033_) || p_150897_1_.m_204336_(BlockTags.f_13035_);
    }

    public float m_8102_(ItemStack p_150893_1_, BlockState p_150893_2_) {
        if (p_150893_2_.m_60713_(Blocks.f_50033_) || p_150893_2_.m_204336_(BlockTags.f_13035_)) {
            return 15.0f;
        }
        Material material = p_150893_2_.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !p_150893_2_.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public Rarity m_41460_(ItemStack pStack) {
        return this.getGearConfig().getRarity();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }
}

