/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.gearconfig;

import com.infamous.dungeons_libraries.data.Codecs;
import com.infamous.dungeons_libraries.items.gearconfig.GearConfigAttributeModifier;
import com.infamous.dungeons_libraries.items.materials.weapon.WeaponMaterials;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class MeleeGearConfig {
    public static final MeleeGearConfig DEFAULT = new MeleeGearConfig(new ArrayList<GearConfigAttributeModifier>(), new ArrayList<EnchantmentInstance>(), new ResourceLocation("minecraft:iron"), false, false, false, false, Rarity.COMMON, 1);
    public static final Codec<MeleeGearConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GearConfigAttributeModifier.CODEC.listOf().optionalFieldOf("attributes", new ArrayList()).forGetter(MeleeGearConfig::getAttributes), (App)Codecs.ENCHANTMENT_DATA_CODEC.listOf().optionalFieldOf("built_in_enchantments", new ArrayList()).forGetter(MeleeGearConfig::getBuiltInEnchantments), (App)ResourceLocation.f_135803_.fieldOf("material").forGetter(armorGearConfig -> armorGearConfig.materialResource), (App)Codec.BOOL.optionalFieldOf("disables_shield", (Object)false).forGetter(MeleeGearConfig::isDisablesShield), (App)Codec.BOOL.optionalFieldOf("light", (Object)false).forGetter(MeleeGearConfig::isLight), (App)Codec.BOOL.optionalFieldOf("two_handed", (Object)false).forGetter(MeleeGearConfig::isTwoHanded), (App)Codec.BOOL.optionalFieldOf("unique", (Object)false).forGetter(MeleeGearConfig::isUnique), (App)Codecs.ITEM_RARITY_CODEC.fieldOf("rarity").forGetter(MeleeGearConfig::getRarity), (App)Codec.INT.optionalFieldOf("combo", (Object)1).forGetter(MeleeGearConfig::getComboLength)).apply((Applicative)instance, MeleeGearConfig::new));
    private final List<GearConfigAttributeModifier> attributes;
    private final List<EnchantmentInstance> builtInEnchantments;
    private final ResourceLocation materialResource;
    private final boolean disablesShield;
    private final boolean light;
    private final boolean twoHanded;
    private final boolean unique;
    private final Rarity rarity;
    private final int comboLength;

    public MeleeGearConfig(List<GearConfigAttributeModifier> attributes, List<EnchantmentInstance> builtInEnchantments, ResourceLocation materialResource, boolean disablesShield, boolean light, boolean twoHanded, boolean unique, Rarity rarity, int comboLength) {
        this.attributes = attributes;
        this.builtInEnchantments = builtInEnchantments;
        this.materialResource = materialResource;
        this.disablesShield = disablesShield;
        this.light = light;
        this.twoHanded = twoHanded;
        this.unique = unique;
        this.rarity = rarity;
        this.comboLength = comboLength;
    }

    public List<GearConfigAttributeModifier> getAttributes() {
        return this.attributes;
    }

    public List<EnchantmentInstance> getBuiltInEnchantments() {
        return this.builtInEnchantments;
    }

    public ResourceLocation getMaterialResource() {
        return this.materialResource;
    }

    public Tier getWeaponMaterial() {
        return WeaponMaterials.getWeaponMaterial(this.materialResource);
    }

    public boolean isDisablesShield() {
        return this.disablesShield;
    }

    public boolean isLight() {
        return this.light;
    }

    public boolean isTwoHanded() {
        return this.twoHanded;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getComboLength() {
        return this.comboLength;
    }
}

