/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.armor;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;

public enum ArmorMaterialBaseType {
    CLOTH("cloth"),
    BONE("bone"),
    LEATHER("leather"),
    METAL("metal"),
    GEM("gem"),
    WOOD("wood"),
    UNKNOWN("unknown");

    public static final Codec<ArmorMaterialBaseType> CODEC;
    private final String name;

    private ArmorMaterialBaseType(String name) {
        this.name = name;
    }

    public static ArmorMaterialBaseType byName(String name, ArmorMaterialBaseType defaultRank) {
        for (ArmorMaterialBaseType factionRank : ArmorMaterialBaseType.values()) {
            if (!factionRank.name.equals(name)) continue;
            return factionRank;
        }
        return defaultRank;
    }

    public String getName() {
        return this.name;
    }

    static {
        CODEC = Codec.STRING.flatComapMap(s -> ArmorMaterialBaseType.byName(s, null), d -> DataResult.success((Object)d.getName()));
    }
}

