/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.items.materials.armor;

import com.infamous.dungeons_libraries.items.materials.armor.ArmorMaterialBaseType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DungeonsArmorMaterial
implements ArmorMaterial {
    public static final Codec<ArmorMaterial> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).m_6082_()), (App)Codec.INT.fieldOf("durability").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).durability), (App)Codec.INT.listOf().fieldOf("damage_reduction_amounts").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).damageReductionAmounts), (App)Codec.INT.fieldOf("enchantability").forGetter(iArmorMaterial -> iArmorMaterial.m_6646_()), (App)ResourceLocation.f_135803_.fieldOf("repair_item").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).repairItemResourceLocation), (App)ForgeRegistries.SOUND_EVENTS.getCodec().fieldOf("equip_sound").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).m_7344_()), (App)Codec.FLOAT.fieldOf("toughness").forGetter(iArmorMaterial -> Float.valueOf(iArmorMaterial.m_6651_())), (App)Codec.FLOAT.fieldOf("knockback_resistance").forGetter(iArmorMaterial -> Float.valueOf(iArmorMaterial.m_6649_())), (App)ArmorMaterialBaseType.CODEC.fieldOf("base_type").forGetter(iArmorMaterial -> ((DungeonsArmorMaterial)iArmorMaterial).baseType)).apply((Applicative)instance, DungeonsArmorMaterial::new));
    private static final int[] BASE_DURABILITY_ARRAY = new int[]{13, 15, 16, 11};
    private final String name;
    private final SoundEvent equipSound;
    private final int durability;
    private final int enchantability;
    private final ResourceLocation repairItemResourceLocation;
    private final LazyLoadedValue<Ingredient> repairItem;
    private final List<Integer> damageReductionAmounts;
    private final float toughness;
    private final float knockbackResistance;
    private final ArmorMaterialBaseType baseType;

    private DungeonsArmorMaterial(String name, int durability, List<Integer> damageReductionAmounts, int enchantability, ResourceLocation repairItemResourceLocation, SoundEvent equipSound, float toughness, float knockbackResistance, ArmorMaterialBaseType baseType) {
        this.name = name;
        this.equipSound = equipSound;
        this.durability = durability;
        this.enchantability = enchantability;
        this.repairItemResourceLocation = repairItemResourceLocation;
        if (ForgeRegistries.ITEMS.containsKey(repairItemResourceLocation)) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(repairItemResourceLocation);
            this.repairItem = new LazyLoadedValue(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        } else {
            this.repairItem = new LazyLoadedValue(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}));
        }
        this.damageReductionAmounts = damageReductionAmounts;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.baseType = baseType;
    }

    public int m_7365_(EquipmentSlot slot) {
        return this.damageReductionAmounts.get(slot.m_20749_());
    }

    public int m_7366_(EquipmentSlot slot) {
        return BASE_DURABILITY_ARRAY[slot.m_20749_()] * this.durability;
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public String m_6082_() {
        return this.name;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairItem.m_13971_();
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public ArmorMaterialBaseType getBaseType() {
        return this.baseType;
    }
}

