/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.mixin;

import com.infamous.dungeons_libraries.DungeonsLibraries;
import com.infamous.dungeons_libraries.utils.RangedAttackHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin {
    private static boolean LOGGED_WARNING = false;

    @Inject(method={"performShooting"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handlePerformShooting(Level level, LivingEntity shooter, InteractionHand useHand, ItemStack crossbow, float velocity, float inaccuracy, CallbackInfo ci) {
        ci.cancel();
        if (!LOGGED_WARNING) {
            DungeonsLibraries.LOGGER.debug("CrossbowItem#performShooting was canceled by Dungeons Libraries and replaced with its CrossbowGear#fireCrossbowProjectiles");
            LOGGED_WARNING = true;
        }
        RangedAttackHelper.fireCrossbowProjectiles(level, shooter, useHand, crossbow, velocity, inaccuracy);
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/CrossbowItem;getShootingPower(Lnet/minecraft/world/item/ItemStack;)F"))
    private float libraries_use_getShootingPower(ItemStack stack, Level level, Player player, InteractionHand hand) {
        return RangedAttackHelper.getCrossbowArrowVelocity((LivingEntity)player, stack);
    }

    @Inject(at={@At(value="RETURN")}, method={"getChargeDuration"}, cancellable=true)
    private static void getChargeDuration(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)((int)RangedAttackHelper.getVanillaCrossbowChargeTime(null, stack)));
    }

    @ModifyConstant(method={"tryLoadProjectiles"}, constant={@Constant(intValue=3, ordinal=0)})
    private static int handleExtraMultishot(int defaultValue, LivingEntity livingEntity, ItemStack itemStack) {
        return 1 + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack) * 2;
    }

    @Inject(method={"getArrow"}, at={@At(value="RETURN")})
    private static void handleGetArrow(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, CallbackInfoReturnable<AbstractArrow> cir) {
        int flameLevel;
        int punchLevel;
        AbstractArrow returnValue = (AbstractArrow)cir.getReturnValue();
        RangedAttackHelper.multiplyRangedDamage(shooter, returnValue);
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)weapon);
        if (powerLevel > 0) {
            returnValue.m_36781_(returnValue.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)weapon)) > 0) {
            returnValue.m_36735_(punchLevel);
        }
        if ((flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)weapon)) > 0) {
            returnValue.m_20254_(100);
        }
    }
}

