/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.mixin;

import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantments;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    private static final Optional<Enchantment> enchantmentOnIteration = null;
    private static final ItemStack itemStackOnIteration = null;

    @Inject(method={"Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getTagEnchantmentLevel(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/item/ItemStack;)I"}, remap=false, at={@At(value="RETURN", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private static void dungeonslibraries_getItemEnchantmentLevelEnchantmentFound(Enchantment enchantment, ItemStack itemStack, CallbackInfoReturnable<Integer> cir, ResourceLocation enchantmentRL, ListTag listNbt, int i, CompoundTag compoundnbt, ResourceLocation found) {
        Integer reduce = EnchantmentHelperMixin.getBuiltInEnchantmentLevel(itemStack, enchantment);
        if (reduce > 0) {
            cir.setReturnValue((Object)((Integer)cir.getReturnValue() - reduce));
        }
    }

    @Inject(method={"Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getTagEnchantmentLevel(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/item/ItemStack;)I"}, remap=false, at={@At(value="RETURN", ordinal=2)}, cancellable=true)
    private static void dungeonslibraries_getItemEnchantmentLevelEnchantmentNotFound(Enchantment enchantment, ItemStack itemStack, CallbackInfoReturnable<Integer> cir) {
        Integer reduce = EnchantmentHelperMixin.getBuiltInEnchantmentLevel(itemStack, enchantment);
        if (reduce > 0) {
            cir.setReturnValue((Object)((Integer)cir.getReturnValue() + reduce));
        }
    }

    @NotNull
    private static Integer getBuiltInEnchantmentLevel(ItemStack itemStack, Enchantment enchantment) {
        BuiltInEnchantments cap = BuiltInEnchantmentsHelper.getBuiltInEnchantmentsCapability(itemStack);
        Integer reduce = cap.getAllBuiltInEnchantmentInstances().stream().filter(enchantmentInstance -> enchantmentInstance.f_44947_ == enchantment).map(enchantmentInstance -> enchantmentInstance.f_44948_).reduce(0, Integer::sum);
        return reduce;
    }

    @Redirect(method={"runIterationOnItem(Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentVisitor;Lnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getAllEnchantments()Ljava/util/Map;", remap=false))
    private static Map dungeonslibraries_getAllEnchantments(ItemStack itemStack) {
        Map enchantmentMap = itemStack.getAllEnchantments();
        HashMap newEnchantmentMap = new HashMap(enchantmentMap);
        BuiltInEnchantments cap = BuiltInEnchantmentsHelper.getBuiltInEnchantmentsCapability(itemStack);
        cap.getAllBuiltInEnchantmentInstances().forEach(enchantmentInstance -> newEnchantmentMap.compute(enchantmentInstance.f_44947_, (enchantment, integer) -> {
            if (integer == null) {
                return enchantmentInstance.f_44948_;
            }
            return integer + enchantmentInstance.f_44948_;
        }));
        return newEnchantmentMap;
    }
}

