/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class BreakItemMessage {
    private final ItemStack stack;
    private final int entityID;

    public BreakItemMessage(int entityID, ItemStack stack) {
        this.stack = stack;
        this.entityID = entityID;
    }

    public static void encode(BreakItemMessage packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityID);
        buf.m_130055_(packet.stack);
    }

    public static BreakItemMessage decode(FriendlyByteBuf buf) {
        return new BreakItemMessage(buf.readInt(), buf.m_130267_());
    }

    public static class BreakItemHandler {
        public static void handle(final BreakItemMessage packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){
                    private static final long serialVersionUID = 1L;

                    public void run() {
                        ClientLevel world = Minecraft.m_91087_().f_91073_;
                        Entity target = null;
                        if (world != null) {
                            target = world.m_6815_(packet.entityID);
                        }
                        if (target instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)target;
                            livingEntity.m_21278_(packet.stack);
                        }
                    }
                }));
            }
        }
    }
}

