/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BuiltInEnchantmentsMessage {
    private final int entityId;
    private final ResourceLocation resourceLocation;
    private final List<EnchantmentInstance> enchantmentInstanceList;

    public BuiltInEnchantmentsMessage(int entityId, ResourceLocation resourceLocation, List<EnchantmentInstance> enchantmentInstanceList) {
        this.entityId = entityId;
        this.resourceLocation = resourceLocation;
        this.enchantmentInstanceList = enchantmentInstanceList;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.m_130085_(this.resourceLocation);
        buffer.m_130130_(this.enchantmentInstanceList.size());
        this.enchantmentInstanceList.forEach(enchantmentInstance -> {
            buffer.m_130085_(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantmentInstance.f_44947_));
            buffer.writeInt(enchantmentInstance.f_44948_);
        });
    }

    public static BuiltInEnchantmentsMessage decode(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        ResourceLocation resourceLocation = buffer.m_130281_();
        ArrayList<EnchantmentInstance> enchantmentInstance = new ArrayList<EnchantmentInstance>();
        int length = buffer.m_130242_();
        for (int x = 0; x < length; ++x) {
            enchantmentInstance.add(new EnchantmentInstance((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_()), buffer.readInt()));
        }
        return new BuiltInEnchantmentsMessage(entityId, resourceLocation, enchantmentInstance);
    }

    public static boolean onPacketReceived(BuiltInEnchantmentsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        return true;
    }
}

