/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network;

import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCaster;
import com.infamous.dungeons_libraries.capabilities.soulcaster.SoulCasterHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class UpdateSoulsMessage {
    private final float newAmount;

    public UpdateSoulsMessage(float souls) {
        this.newAmount = souls;
    }

    public static void encode(UpdateSoulsMessage packet, FriendlyByteBuf buf) {
        buf.writeFloat(packet.newAmount);
    }

    public static UpdateSoulsMessage decode(FriendlyByteBuf buf) {
        return new UpdateSoulsMessage(buf.readFloat());
    }

    public static class UpdateSoulsHandler {
        public static void handle(final UpdateSoulsMessage packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet != null) {
                ctx.get().setPacketHandled(true);
                ctx.get().enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){
                    private static final long serialVersionUID = 1L;

                    public void run() {
                        LocalPlayer player = Minecraft.m_91087_().f_91074_;
                        if (player != null) {
                            SoulCaster soulCasterCap = SoulCasterHelper.getSoulCasterCapability((Entity)player);
                            soulCasterCap.setSouls(packet.newAmount, (LivingEntity)player);
                        }
                    }
                }));
            }
        }
    }
}

