/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.network.client;

import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsage;
import com.infamous.dungeons_libraries.capabilities.artifact.ArtifactUsageHelper;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMob;
import com.infamous.dungeons_libraries.capabilities.elite.EliteMobHelper;
import com.infamous.dungeons_libraries.integration.curios.client.message.CuriosArtifactStopMessage;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.network.EliteMobMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ClientHandler {
    public static void handleCuriosArtifactStopMessage(CuriosArtifactStopMessage packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context;
        if (packet != null && (context = ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Item patt1719$temp;
                ArtifactUsage cap;
                ItemStack artifactStack;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null && (artifactStack = (cap = ArtifactUsageHelper.getArtifactUsageCapability((Entity)player)).getUsingArtifact()) != null && (patt1719$temp = artifactStack.m_41720_()) instanceof ArtifactItem) {
                    ArtifactItem artifactItem = (ArtifactItem)patt1719$temp;
                    artifactItem.stopUsingArtifact((LivingEntity)player);
                    cap.stopUsingArtifact();
                }
            });
        }
    }

    public static void handleEliteMobMessage(EliteMobMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(message.getEntityId());
                if (entity instanceof LivingEntity) {
                    EliteMob cap = EliteMobHelper.getEliteMobCapability(entity);
                    cap.setElite(message.isElite());
                    cap.setTexture(message.getTexture());
                    if (cap.isElite()) {
                        entity.m_6210_();
                    }
                }
            });
        }
    }
}

