/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.summon;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Follower;
import com.infamous.dungeons_libraries.capabilities.minionmaster.FollowerLeaderHelper;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Leader;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Master;
import com.infamous.dungeons_libraries.entities.ai.goal.MeleeAttackGoal;
import com.infamous.dungeons_libraries.summon.SummonConfig;
import com.infamous.dungeons_libraries.summon.SummonConfigRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.registries.ForgeRegistries;

public class SummonHelper {
    private static boolean addSummonedMob(LivingEntity master, Entity entity) {
        Leader leaderCapability = FollowerLeaderHelper.getLeaderCapability((Entity)master);
        if (SummonHelper.canSummonMob(master, entity, leaderCapability)) {
            return leaderCapability.addSummonedMob(entity);
        }
        return false;
    }

    private static boolean canSummonMob(LivingEntity leader, Entity beeEntity, Leader leaderCap) {
        AttributeInstance summonCapAttribute = leader.m_21051_((Attribute)AttributeRegistry.SUMMON_CAP.get());
        if (summonCapAttribute == null) {
            return false;
        }
        return (double)(leaderCap.getSummonedMobsCost() + SummonConfigRegistry.getConfig(ForgeRegistries.ENTITY_TYPES.getKey((Object)beeEntity.m_6095_())).getCost()) <= summonCapAttribute.m_22135_();
    }

    public static boolean canSummonMob(LivingEntity master, Master masterCap) {
        return SummonHelper.canSummonMob(master, (Leader)masterCap);
    }

    public static boolean canSummonMob(LivingEntity master, Leader leaderCap) {
        AttributeInstance summonCostLimitAttribute = master.m_21051_((Attribute)AttributeRegistry.SUMMON_CAP.get());
        if (summonCostLimitAttribute == null) {
            return false;
        }
        return (double)leaderCap.getSummonedMobsCost() < summonCostLimitAttribute.m_22135_();
    }

    public static Entity summonEntity(LivingEntity leader, BlockPos position, EntityType<?> entityType) {
        Entity entity = entityType.m_20615_(leader.f_19853_);
        if (entity != null) {
            Follower summonable = FollowerLeaderHelper.getFollowerCapability(entity);
            if (SummonHelper.addSummonedMob(leader, entity)) {
                summonable.setLeader(leader);
                summonable.setSummon(true);
                SummonHelper.createSummon(leader, entity, position);
                return entity;
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return null;
    }

    private static void createSummon(LivingEntity master, Entity entity, BlockPos position) {
        entity.m_7678_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.05, (double)position.m_123343_() + 0.5, 0.0f, 0.0f);
        if (entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            FollowerLeaderHelper.addFollowerGoals(mobEntity);
        }
        master.f_19853_.m_7967_(entity);
    }

    public static void addSummonGoals(Mob mobEntity) {
        SummonConfig config;
        Follower followerCap = FollowerLeaderHelper.getFollowerCapability((Entity)mobEntity);
        if (followerCap.isSummon() && (config = SummonConfigRegistry.getConfig(ForgeRegistries.ENTITY_TYPES.getKey((Object)mobEntity.m_6095_()))).shouldAddAttackGoal()) {
            SummonHelper.addSummonAttackGoal(mobEntity);
        }
    }

    private static void addSummonAttackGoal(Mob mobEntity) {
        AttributeInstance attribute = mobEntity.m_21051_(Attributes.f_22281_);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22135_() == 0.0) {
            attribute.m_22118_(new AttributeModifier("Summon Attack Damage", 1.0, AttributeModifier.Operation.ADDITION));
        }
        mobEntity.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal(mobEntity, 1.0, true));
    }
}

