/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.config.DungeonsLibrariesConfig;
import com.infamous.dungeons_libraries.mixin.BrainAccessor;
import com.infamous.dungeons_libraries.mixin.NearestAttackableTargetGoalAccessor;
import com.infamous.dungeons_libraries.mixin.TargetingConditionsAccessor;
import com.infamous.dungeons_libraries.utils.PetHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AbilityHelper {
    public static boolean isFacingEntity(Entity looker, Entity target, Vec3 look, int angle) {
        double cos;
        if (angle <= 0) {
            return false;
        }
        Vec3 posVec = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        Vec3 relativePosVec = posVec.m_82505_(looker.m_20182_().m_82520_(0.0, (double)looker.m_20192_(), 0.0)).m_82541_();
        double dotsq = relativePosVec.m_82526_(look) * Math.abs(relativePosVec.m_82526_(look)) / (relativePosVec.m_82556_() * look.m_82556_());
        return dotsq < -((cos = (double)Mth.m_14089_((float)((float)((double)angle / 360.0 * Math.PI)))) * cos);
    }

    private static boolean isNotTheTargetOrAttacker(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return nearbyEntity != target && nearbyEntity != attacker;
    }

    private static boolean isBothPlayerAndNoPvP(LivingEntity attacker, LivingEntity nearbyEntity) {
        return attacker instanceof Player && nearbyEntity instanceof Player && (Boolean)DungeonsLibrariesConfig.ENABLE_AREA_OF_EFFECT_ON_OTHER_PLAYERS.get() == false;
    }

    public static boolean canHealEntity(LivingEntity healer, LivingEntity nearbyEntity) {
        return nearbyEntity != healer && AbilityHelper.isAlly(healer, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, healer);
    }

    public static boolean isAlly(LivingEntity origin, LivingEntity target) {
        LivingEntity originOwner = PetHelper.getOwner(origin);
        LivingEntity targetOwner = PetHelper.getOwner(target);
        if (originOwner != null || targetOwner != null) {
            return AbilityHelper.isAlly(originOwner != null ? originOwner : origin, targetOwner != null ? targetOwner : target);
        }
        return PetHelper.isPetOrColleagueRelation(origin, target) || origin.m_7307_((Entity)target) || AbilityHelper.isBothPlayerAndNoPvP(origin, target) || AbilityHelper.isEntityBlacklisted(origin, target) || AbilityHelper.isDefaultEnemy(origin) && AbilityHelper.isDefaultEnemy(target) && !AbilityHelper.matchesAITargets(origin, target);
    }

    public static boolean isDefaultEnemy(LivingEntity origin) {
        return origin.getClassification(false).equals((Object)MobCategory.MONSTER);
    }

    private static boolean matchesAITargets(LivingEntity origin, LivingEntity target) {
        if (!((Boolean)DungeonsLibrariesConfig.ENABLE_TARGETS_BASED_ON_GOALS.get()).booleanValue() || !(origin instanceof Mob)) {
            return true;
        }
        Mob originMob = (Mob)origin;
        return AbilityHelper.checkTargetGoals(originMob, target);
    }

    @NotNull
    private static Boolean checkTargetGoals(Mob originMob, LivingEntity target) {
        return originMob.f_21346_.m_148105_().stream().map(WrappedGoal::m_26015_).filter(goal -> goal instanceof NearestAttackableTargetGoal).map(goal -> AbilityHelper.matchesPredicate(target, ((NearestAttackableTargetGoalAccessor)goal).getTargetType(), ((NearestAttackableTargetGoalAccessor)goal).getTargetConditions())).reduce(false, (o, o2) -> o != false || o2 != false);
    }

    private static boolean matchesPredicate(LivingEntity target, Class targetType, TargetingConditions targetConditions) {
        Predicate<LivingEntity> selector = ((TargetingConditionsAccessor)targetConditions).getSelector();
        return !(targetType != null && !targetType.isInstance(target) || selector != null && !selector.test(target));
    }

    public static <E extends LivingEntity> BrainAccessor<E> castToAccessor(Brain<E> brain) {
        return (BrainAccessor)brain;
    }

    private static boolean isEntityBlacklisted(LivingEntity origin, LivingEntity target) {
        if (target.m_6095_().equals(EntityType.f_20529_)) {
            return true;
        }
        return origin instanceof Player && !AbilityHelper.isDefaultEnemy(target) && (!((List)DungeonsLibrariesConfig.ENEMY_WHITELIST.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString()) || ((List)DungeonsLibrariesConfig.ENEMY_BLACKLIST.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString()));
    }

    private static boolean isAliveAndCanBeSeen(LivingEntity nearbyEntity, LivingEntity attacker) {
        return nearbyEntity.m_6084_() && attacker.m_142582_((Entity)nearbyEntity);
    }

    public static boolean canApplyToSecondEnemy(LivingEntity attacker, LivingEntity target, LivingEntity nearbyEntity) {
        return AbilityHelper.isNotTheTargetOrAttacker(attacker, target, nearbyEntity) && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity);
    }

    public static boolean canApplyToEnemy(LivingEntity attacker, LivingEntity nearbyEntity) {
        return nearbyEntity != attacker && AbilityHelper.isAliveAndCanBeSeen(nearbyEntity, attacker) && !AbilityHelper.isAlly(attacker, nearbyEntity);
    }
}

