/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectile;
import com.infamous.dungeons_libraries.capabilities.enchantedprojectile.EnchantedProjectileHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_libraries")
public class ArrowHelper {
    @SubscribeEvent
    public static void onArrowJoinWorld(EntityJoinLevelEvent event) {
        AbstractArrow arrowEntity;
        Entity shooterEntity;
        if (event.getEntity() instanceof AbstractArrow && (shooterEntity = (arrowEntity = (AbstractArrow)event.getEntity()).m_37282_()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)shooterEntity;
            ItemStack mainhandStack = shooter.m_21205_();
            ItemStack offhandStack = shooter.m_21206_();
            if (mainhandStack.m_41720_() instanceof BowItem || mainhandStack.m_41720_() instanceof CrossbowItem) {
                ArrowHelper.handleRangedEnchantments(arrowEntity, shooter, mainhandStack);
            } else if (offhandStack.m_41720_() instanceof BowItem || offhandStack.m_41720_() instanceof CrossbowItem) {
                ArrowHelper.handleRangedEnchantments(arrowEntity, shooter, offhandStack);
            }
        }
    }

    private static void handleRangedEnchantments(AbstractArrow arrowEntity, LivingEntity shooter, ItemStack stack) {
        ArrowHelper.addEnchantmentTagsToArrow(stack, (Projectile)arrowEntity);
    }

    public static boolean hasEnchantment(ItemStack stack, Enchantment enchantment) {
        return enchantment != null && EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack) > 0;
    }

    public static boolean hasEnchantment(LivingEntity entity, Enchantment enchantment) {
        return enchantment != null && EnchantmentHelper.m_44836_((Enchantment)enchantment, (LivingEntity)entity) > 0;
    }

    public static boolean shooterIsLiving(AbstractArrow arrowEntity) {
        return arrowEntity.m_37282_() != null && arrowEntity.m_37282_() instanceof LivingEntity;
    }

    public static boolean arrowHitLivingEntity(HitResult hitResult) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.m_82443_() instanceof LivingEntity;
        }
        return false;
    }

    public static boolean arrowHitMob(HitResult hitResult) {
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            return entityHitResult.m_82443_() instanceof Mob;
        }
        return false;
    }

    public static void addEnchantmentTagsToArrow(ItemStack itemStack, Projectile projectileEntity) {
        EnchantedProjectile cap = EnchantedProjectileHelper.getEnchantedProjectileCapability((Entity)projectileEntity);
        cap.setEnchantments(itemStack);
    }

    public static int enchantmentTagToLevel(Projectile projectileEntity, Enchantment enchantment) {
        EnchantedProjectile cap = EnchantedProjectileHelper.getEnchantedProjectileCapability((Entity)projectileEntity);
        return cap.getEnchantmentLevel(enchantment);
    }
}

