/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.google.common.collect.Multimap;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantments;
import com.infamous.dungeons_libraries.capabilities.builtinenchants.BuiltInEnchantmentsHelper;
import com.infamous.dungeons_libraries.items.artifacts.ArtifactItem;
import com.infamous.dungeons_libraries.items.gearconfig.MeleeGearConfigRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="dungeons_libraries", value={Dist.CLIENT})
public class DescriptionHelper {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        BuiltInEnchantments cap = BuiltInEnchantmentsHelper.getBuiltInEnchantmentsCapability(event.getItemStack());
        List<EnchantmentInstance> builtInEnchantments = cap.getBuiltInEnchantments(MeleeGearConfigRegistry.GEAR_CONFIG_BUILTIN_RESOURCELOCATION);
        builtInEnchantments.forEach(enchantmentInstance -> event.getToolTip().add(enchantmentInstance.f_44947_.m_44700_(enchantmentInstance.f_44948_).m_6881_().m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)"#FF8100")))));
    }

    public static void addArtifactDescription(List<Component> list, ItemStack itemStack) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (registryName == null) {
            return;
        }
        DescriptionHelper.addLoreDescription(list, registryName);
        DescriptionHelper.addArtifactInfo(list, itemStack);
        DescriptionHelper.addArtifactAttributeInfo(list, itemStack);
    }

    private static void addArtifactAttributeInfo(List<Component> list, ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof ArtifactItem)) {
            return;
        }
        ArtifactItem artifactItem = (ArtifactItem)item;
        Multimap<Attribute, AttributeModifier> multimap = artifactItem.getDefaultAttributeModifiers(0);
        if (!multimap.isEmpty()) {
            list.add(CommonComponents.f_237098_);
            list.add((Component)Component.m_237115_((String)"item.modifiers.artifact").m_130940_(ChatFormatting.GRAY));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.m_22218_();
                double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
                if (d0 > 0.0) {
                    list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static void addArtifactInfo(List<Component> list, ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ArtifactItem) {
            list.add((Component)Component.m_237115_((String)"artifact.dungeons_libraries.base").m_130940_(ChatFormatting.DARK_AQUA));
            ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            list.add((Component)Component.m_237115_((String)("ability." + registryName.m_135827_() + "." + registryName.m_135815_())).m_130940_(ChatFormatting.GREEN));
            ArtifactItem artifactItem = (ArtifactItem)itemStack.m_41720_();
            int durationInSeconds = artifactItem.getDurationInSeconds();
            int cooldownInSeconds = artifactItem.getCooldownInSeconds();
            if (durationInSeconds > 0) {
                list.add((Component)Component.m_237110_((String)"artifact.dungeons_libraries.duration", (Object[])new Object[]{durationInSeconds}).m_130940_(ChatFormatting.BLUE));
            }
            if (cooldownInSeconds > 0) {
                list.add((Component)Component.m_237110_((String)"artifact.dungeons_libraries.cooldown", (Object[])new Object[]{cooldownInSeconds}).m_130940_(ChatFormatting.BLUE));
            }
        }
    }

    public static void addFullDescription(List<Component> list, ItemStack itemStack) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        DescriptionHelper.addLoreDescription(list, registryName);
    }

    public static void addLoreDescription(List<Component> list, ResourceLocation registryName) {
        list.add((Component)Component.m_237115_((String)("lore." + registryName.m_135827_() + "." + registryName.m_135815_())).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}));
    }

    public static void addChargeableDescription(List<Component> list, ItemStack itemStack) {
    }
}

