/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.capabilities.minionmaster.FollowerLeaderHelper;
import com.infamous.dungeons_libraries.capabilities.minionmaster.Leader;
import com.infamous.dungeons_libraries.utils.AbilityHelper;
import java.util.HashSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public class PetHelper {
    public static void makeNearbyPetsAttackTarget(LivingEntity target, LivingEntity owner) {
        if (PetHelper.isPetOf(target, owner) || PetHelper.isPetOf(owner, target)) {
            return;
        }
        Leader leaderCapability = FollowerLeaderHelper.getLeaderCapability((Entity)owner);
        List nearbyEntities = owner.m_20193_().m_6443_(LivingEntity.class, owner.m_20191_().m_82400_(12.0), nearbyEntity -> PetHelper.isPetOf(owner, nearbyEntity));
        HashSet<Entity> pets = new HashSet<Entity>();
        pets.addAll(leaderCapability.getAllFollowers());
        pets.addAll(nearbyEntities);
        for (Entity pet : pets) {
            if (!(pet instanceof Mob)) continue;
            ((Mob)pet).m_6710_(target);
        }
    }

    public static boolean canPetAttackEntity(LivingEntity pet, LivingEntity target) {
        return pet.m_6084_() && AbilityHelper.canApplyToEnemy(pet, target);
    }

    public static boolean isPetOf(LivingEntity possibleOwner, LivingEntity possiblePet) {
        return PetHelper.getOwner(possiblePet) == possibleOwner;
    }

    public static boolean isPetOrColleagueRelation(LivingEntity potentialPet1, LivingEntity potentialPet2) {
        LivingEntity owner = PetHelper.getOwner(potentialPet1);
        LivingEntity otherOwner = PetHelper.getOwner(potentialPet2);
        if (owner == null) {
            return potentialPet1 == otherOwner;
        }
        if (otherOwner == null) {
            return potentialPet2 == owner;
        }
        return owner == otherOwner;
    }

    public static LivingEntity getOwner(LivingEntity potentialPet) {
        LivingEntity leader;
        LivingEntity owner = null;
        if (potentialPet instanceof TamableAnimal) {
            owner = ((TamableAnimal)potentialPet).m_21826_();
        }
        if (potentialPet instanceof AbstractHorse) {
            owner = FollowerLeaderHelper.getOwnerForHorse((AbstractHorse)potentialPet);
        }
        if ((leader = FollowerLeaderHelper.getLeader(potentialPet)) != null) {
            owner = leader;
        }
        return owner;
    }
}

