/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_libraries.utils;

import com.infamous.dungeons_libraries.attribute.AttributeRegistry;
import com.infamous.dungeons_libraries.event.BowEvent;
import com.infamous.dungeons_libraries.event.CrossbowEvent;
import com.infamous.dungeons_libraries.items.gearconfig.BowGear;
import com.infamous.dungeons_libraries.items.gearconfig.CrossbowGear;
import com.infamous.dungeons_libraries.mixin.CrossbowItemInvoker;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class RangedAttackHelper {
    public static float getBowArrowVelocity(LivingEntity livingEntity, ItemStack stack, int charge) {
        float bowChargeTime = RangedAttackHelper.getBowChargeTime(livingEntity, stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f;
        float velocityLimit = 1.0f;
        BowEvent.Overcharge overchargeEvent = new BowEvent.Overcharge(livingEntity, stack, 0);
        MinecraftForge.EVENT_BUS.post((Event)overchargeEvent);
        int overchargeLevel = overchargeEvent.getCharges();
        if (overchargeLevel > 0) {
            velocityLimit += (float)overchargeLevel;
        }
        if (arrowVelocity > velocityLimit) {
            arrowVelocity = velocityLimit;
        }
        BowEvent.Velocity velocityEvent = new BowEvent.Velocity(livingEntity, stack, arrowVelocity);
        MinecraftForge.EVENT_BUS.post((Event)velocityEvent);
        return velocityEvent.getVelocity();
    }

    public static float getBowChargeTime(LivingEntity livingEntity, ItemStack stack) {
        float defaultChargeTime = stack.m_41720_() instanceof BowGear ? ((BowGear)stack.m_41720_()).getDefaultChargeTime() : 20.0f;
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float minTime = 1.0f;
        BowEvent.ChargeTime event = new BowEvent.ChargeTime(livingEntity, stack, defaultChargeTime);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(event.getChargeTime() - (float)(5 * quickChargeLevel), minTime);
    }

    public static float getVanillaCrossbowChargeTime(@Nullable LivingEntity livingEntity, ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float minTime = 1.0f;
        CrossbowEvent.ChargeTime event = new CrossbowEvent.ChargeTime(livingEntity, stack, 25.0f);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return Math.max(event.getChargeTime() - (float)(5 * quickChargeLevel), minTime);
    }

    public static float getCrossbowChargeTime(@Nullable LivingEntity livingEntity, ItemStack stack) {
        float chargeTime;
        Item item = stack.m_41720_();
        if (item instanceof CrossbowGear) {
            CrossbowGear crossbowGear = (CrossbowGear)item;
            chargeTime = crossbowGear.getCrossbowChargeTime(livingEntity, stack);
        } else {
            chargeTime = RangedAttackHelper.getVanillaCrossbowChargeTime(livingEntity, stack);
        }
        return chargeTime;
    }

    public static float getCrossbowArrowVelocity(@Nullable LivingEntity livingEntity, ItemStack stack) {
        float baseVelocity = 3.15f;
        if (CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_)) {
            baseVelocity = 1.6f;
        }
        CrossbowEvent.Velocity event = new CrossbowEvent.Velocity(livingEntity, stack, baseVelocity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getVelocity();
    }

    public static float getAngleForProjectileByIndex(int projectileIndex) {
        int indexScale = projectileIndex / 2;
        return 10.0f * (projectileIndex % 2 != 0 ? (float)(indexScale + 1) : (float)indexScale * -1.0f);
    }

    public static void multiplyRangedDamage(LivingEntity shooter, AbstractArrow arrow) {
        AttributeInstance rangedDamageMultiplier = shooter.m_21051_((Attribute)AttributeRegistry.RANGED_DAMAGE_MULTIPLIER.get());
        if (rangedDamageMultiplier != null) {
            arrow.m_36781_(arrow.m_36789_() * rangedDamageMultiplier.m_22135_());
        }
    }

    public static void createBowArrow(ItemStack bowStack, Level world, Player player, ItemStack projectileStack, float powerForTime, int arrowIndex, boolean isInfiniteArrow) {
        int piercingLevel;
        int flameLevel;
        int punchLevel;
        int powerLevel;
        ArrowItem arrowitem = (ArrowItem)(projectileStack.m_41720_() instanceof ArrowItem ? projectileStack.m_41720_() : Items.f_42412_);
        AbstractArrow arrow = arrowitem.m_6394_(world, projectileStack, (LivingEntity)player);
        Item item = bowStack.m_41720_();
        if (item instanceof BowItem) {
            BowItem bowItem = (BowItem)item;
            bowItem.customArrow(arrow);
        }
        RangedAttackHelper.multiplyRangedDamage((LivingEntity)player, arrow);
        arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_() + RangedAttackHelper.getAngleForProjectileByIndex(arrowIndex), 0.0f, powerForTime * 3.0f, 1.0f);
        if (powerForTime >= 1.0f) {
            arrow.m_36762_(true);
        }
        if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack)) > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack)) > 0) {
            arrow.m_36735_(punchLevel);
        }
        if ((flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack)) > 0) {
            arrow.m_20254_(100);
        }
        if ((piercingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)bowStack)) > 0) {
            arrow.m_36767_((byte)piercingLevel);
        }
        bowStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        if (isInfiniteArrow || player.m_150110_().f_35937_ && RangedAttackHelper.isSpecialArrow(projectileStack) || arrowIndex > 0) {
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        world.m_7967_((Entity)arrow);
    }

    private static boolean isSpecialArrow(ItemStack projectileStack) {
        return projectileStack.m_150930_(Items.f_42737_) || projectileStack.m_150930_(Items.f_42738_);
    }

    public static void fireCrossbowProjectiles(Level world, LivingEntity livingEntity, InteractionHand hand, ItemStack stack, float velocityIn, float inaccuracyIn) {
        Player player;
        if (livingEntity instanceof Player && ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)livingEntity.f_19853_, (Player)(player = (Player)livingEntity), (int)1, (boolean)true) < 0) {
            return;
        }
        List<ItemStack> list = CrossbowItemInvoker.callGetChargedProjectiles(stack);
        float[] randomSoundPitches = CrossbowItemInvoker.callGetShotPitches(livingEntity.m_217043_());
        for (int projectileIndex = 0; projectileIndex < list.size(); ++projectileIndex) {
            boolean playerInCreativeMode;
            ItemStack currentProjectile = list.get(projectileIndex);
            boolean bl = playerInCreativeMode = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
            if (currentProjectile.m_41619_()) continue;
            float projectileAngle = RangedAttackHelper.getAngleForProjectileByIndex(projectileIndex);
            CrossbowItemInvoker.callShootProjectile(world, livingEntity, hand, stack, currentProjectile, randomSoundPitches[projectileIndex == 0 ? 0 : (projectileIndex % 2 != 0 ? 1 : 2)], playerInCreativeMode, velocityIn, inaccuracyIn, projectileAngle);
        }
        CrossbowItemInvoker.callOnCrossbowShot(world, livingEntity, stack);
    }
}

